/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.constant;

import java.util.Arrays;
import java.util.List;

public enum AppIdEnum {
    TCVAT("tcvat", new String[]{"zzsybnsr", "zzsybnsr_zjg", "zzsybnsr_fzjg", "zzsxgmnsr", "fjsf", "zzsybnsr_ybhz"}),
    TCCIT("tccit", new String[]{"qysdsjb", "qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_jb", "qysds_hdzs_nb"}),
    TCSD("tcsd", new String[]{"yhs"}),
    TCRET("tcret", new String[]{"fcscztdsys"}),
    TCCT("tcct", new String[]{"xfs", "xfsjypf", "fjsf"}),
    TOTF("totf", new String[]{"fjsf", "tcept", "tcrt", "yys", "tcvvt"}),
    TCVVT_("tcvvt", new String[]{"FR0001", "FR0002"});

    private String appId;
    private String[] templates;

    private AppIdEnum(String appId, String[] templates) {
        this.appId = appId;
        this.templates = templates;
    }

    public String getAppId() {
        return this.appId;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }

    public String[] getTemplates() {
        return this.templates;
    }

    private void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public static String valueOfTaxType(String taxType) {
        for (AppIdEnum appIdEnum : AppIdEnum.values()) {
            List<String> taxTypes = Arrays.asList(appIdEnum.getTemplates());
            if (!taxTypes.contains(taxType)) continue;
            return appIdEnum.getAppId();
        }
        return null;
    }
}

