/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.constant;

import java.util.Arrays;
import java.util.Optional;

public enum SupplierEnum {
    ZWY("kd", "1", 1474506853966002176L),
    CLOUDCC("cloudcc", "2", 1474508210001262592L),
    SZYH("szyh", "3", 1474507120782456832L),
    GZDZSJ("gzdzsj", "4", 1474507471526687744L),
    YZF("yzf", "5", 1474507721263936512L),
    GXSJ("gxdzsj", "6", 1474507907214210048L),
    HBDZSJ("hbdzsj", "7", 1474508043026020352L),
    CMS("cms", "9", 1918898390469752832L),
    QXY("qxy", "8", 1762344551743240192L);

    private String name;
    private String code;
    private Long id;

    private SupplierEnum(String name, String code, Long id) {
        this.name = name;
        this.code = code;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public Long getId() {
        return this.id;
    }

    public boolean codeEqual(String code) {
        return this.code.equals(code);
    }

    public static SupplierEnum valueOfCode(String code) {
        for (SupplierEnum item : SupplierEnum.values()) {
            if (!item.getCode().equals(code)) continue;
            return item;
        }
        return null;
    }

    public static SupplierEnum valueOfId(Long id) {
        Optional<SupplierEnum> op = Arrays.stream(SupplierEnum.values()).filter(item -> item.getId().equals(id)).findFirst();
        return op.isPresent() ? op.get() : null;
    }
}

