/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.enums;

import java.util.Arrays;
import java.util.Optional;

public enum ExecuteTypeEnums {
    ZLSB("ZLSB", "directdeclare", 1474509058752231424L),
    ZLJK("ZLJK", "fastpay", 1474509156135334912L),
    SJYZ("SJYZ", "verify", 1478158897171891200L),
    SBJT("SBJT", "sbjt", 1474509899735349248L),
    KKJT("KKJT", "kkjt", 1474510147610327040L),
    WSPZ("WSPZ", "wspz", 1474510267038692352L),
    TBZT("TBZT", "tbzt", 1474510385603524608L),
    SBZF("SBZF", "undo", 1515311838211127296L),
    YYJK("YYJK", "yyjk", 1478127666417688576L),
    LSXZ("LSXZ", "lsxz", 1489098237402113024L),
    QCXZ("QCXZ", "qcxz", 1820373599975259136L),
    SBBFILE("SBBFILE", "sbbfile", 1624546066894566400L),
    SFZHDXX("SFZHDXX", "sfzhdxx", 1544252917123394560L),
    JKPZFX("JKPZFX", "jkpzfx", 1837815063420201984L),
    CKBGDXZ("CKBGDXZ", "ckbgdxz", 1923265198383559680L),
    SBQC("SBSXXZ", "sbsxxz", 1513647653735701504L);

    private String executeType;
    private String key;
    private Long id;

    private ExecuteTypeEnums(String executeType, String key, Long id) {
        this.executeType = executeType;
        this.key = key;
        this.id = id;
    }

    public String getExecuteType() {
        return this.executeType;
    }

    public String getKey() {
        return this.key;
    }

    public Long getId() {
        return this.id;
    }

    public static String getKeyByExecuteType(String executeType) {
        ExecuteTypeEnums type = ExecuteTypeEnums.valuesOfExecuteType(executeType);
        return type == null ? "" : type.getKey();
    }

    public static String getExcuteTypeByKey(String key) {
        ExecuteTypeEnums type = ExecuteTypeEnums.valuesOfKey(key);
        return type == null ? "" : type.getExecuteType();
    }

    public static ExecuteTypeEnums valuesOfKey(String key) {
        for (ExecuteTypeEnums value : ExecuteTypeEnums.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        return null;
    }

    public static ExecuteTypeEnums valuesOfExecuteType(String executeType) {
        for (ExecuteTypeEnums value : ExecuteTypeEnums.values()) {
            if (!value.getExecuteType().equals(executeType)) continue;
            return value;
        }
        return null;
    }

    public static ExecuteTypeEnums valuesOfId(Long id) {
        if (id == null) {
            return null;
        }
        Optional<ExecuteTypeEnums> op = Arrays.stream(ExecuteTypeEnums.values()).filter(item -> item.getId().equals(id)).findFirst();
        return op.isPresent() ? op.get() : null;
    }
}

