/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.enums;

import java.util.Arrays;
import java.util.Optional;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;

public enum SupportHistoryDataEnum {
    ZWY(SupplierEnum.ZWY, new DeclareTypeEnum[]{DeclareTypeEnum.ZZSYBNSR, DeclareTypeEnum.QYSDSJB}),
    QXY(SupplierEnum.QXY, new DeclareTypeEnum[]{DeclareTypeEnum.ZZSYBNSR, DeclareTypeEnum.ZZSXGMNSR, DeclareTypeEnum.FR0002, DeclareTypeEnum.FR0003});

    private SupplierEnum supplier;
    private final DeclareTypeEnum[] declareTypes;

    private SupportHistoryDataEnum(SupplierEnum supplier, DeclareTypeEnum[] declareTypes) {
        this.supplier = supplier;
        this.declareTypes = declareTypes;
    }

    public SupplierEnum getSupplier() {
        return this.supplier;
    }

    public void setSupplier(SupplierEnum supplier) {
        this.supplier = supplier;
    }

    public boolean containsType(DeclareTypeEnum declareType) {
        Optional<DeclareTypeEnum> op = Arrays.stream(this.declareTypes).filter(type -> type == declareType).findAny();
        return op.isPresent();
    }

    public static SupportHistoryDataEnum valueOfSupplier(SupplierEnum supplier) {
        Optional<SupportHistoryDataEnum> op = Arrays.stream(SupportHistoryDataEnum.values()).filter(support -> support.getSupplier() == supplier).findFirst();
        return op.isPresent() ? op.get() : null;
    }
}

