/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.enums;

import java.util.Arrays;
import java.util.Optional;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;

public enum SupportQcDataEnum {
    ZWY(SupplierEnum.ZWY, new DeclareTypeEnum[]{DeclareTypeEnum.ZZSYBNSR, DeclareTypeEnum.ZDSYBS_YD}),
    QXY(SupplierEnum.QXY, new DeclareTypeEnum[]{DeclareTypeEnum.ZZSYBNSR, DeclareTypeEnum.FR0002, DeclareTypeEnum.FR0003, DeclareTypeEnum.ZZSXGMNSR});

    private SupplierEnum supplier;
    private final DeclareTypeEnum[] declareTypes;

    private SupportQcDataEnum(SupplierEnum supplier, DeclareTypeEnum[] declareTypes) {
        this.supplier = supplier;
        this.declareTypes = declareTypes;
    }

    public SupplierEnum getSupplier() {
        return this.supplier;
    }

    public void setSupplier(SupplierEnum supplier) {
        this.supplier = supplier;
    }

    public boolean containsType(DeclareTypeEnum declareType) {
        Optional<DeclareTypeEnum> op = Arrays.stream(this.declareTypes).filter(type -> type == declareType).findAny();
        return op.isPresent();
    }

    public static SupportQcDataEnum valueOfSupplier(SupplierEnum supplier) {
        Optional<SupportQcDataEnum> op = Arrays.stream(SupportQcDataEnum.values()).filter(support -> support.getSupplier() == supplier).findFirst();
        return op.isPresent() ? op.get() : null;
    }
}

