/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.enums;

import java.util.Arrays;
import java.util.List;
import kd.taxc.tsate.common.enums.TaxPeriodType;

public enum TaxSupportPeriodEnum {
    ZZSYBNSR("zzsybnsr", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON)),
    ZZSXGMNSR("zzsxgmnsr", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON)),
    QYSDSJB("qysdsjb", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON)),
    FR0001("FR0001", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.YEAR)),
    FR0002("FR0002", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.YEAR)),
    FR0003("FR0003", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.YEAR)),
    FR0004("FR0004", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.YEAR)),
    FR0011("FR0011", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.YEAR)),
    YHS("yhs", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.HALFYEAR, TaxPeriodType.YEAR, TaxPeriodType.SINGLE)),
    FCSCZTDSYS("fcscztdsys", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.HALFYEAR, TaxPeriodType.YEAR)),
    QTSF_FSSTYSBB("qtsf_fsstysbb", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.HALFYEAR, TaxPeriodType.YEAR, TaxPeriodType.SINGLE)),
    QTSF_TYSBB("qtsf_tysbb", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.HALFYEAR, TaxPeriodType.YEAR, TaxPeriodType.SINGLE)),
    XFSJFJ("xfsjfj", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON)),
    TOTF_CJRJYBZJ("totf_cjrjybzj", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.HALFYEAR, TaxPeriodType.YEAR, TaxPeriodType.SINGLE)),
    WHSYJSF("whsyjsf", Arrays.asList(TaxPeriodType.MONTH, TaxPeriodType.SEASON, TaxPeriodType.HALFYEAR, TaxPeriodType.YEAR, TaxPeriodType.SINGLE));

    private String taxType;
    private List<TaxPeriodType> supportPeriod;

    private TaxSupportPeriodEnum(String taxType, List<TaxPeriodType> supportPeriod) {
        this.taxType = taxType;
        this.supportPeriod = supportPeriod;
    }

    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public List<TaxPeriodType> getSupportPeriod() {
        return this.supportPeriod;
    }

    public void setSupportPeriod(List<TaxPeriodType> supportPeriod) {
        this.supportPeriod = supportPeriod;
    }

    public static List<TaxPeriodType> getSupportPeriodByTaxType(String taxType) {
        for (TaxSupportPeriodEnum value : TaxSupportPeriodEnum.values()) {
            if (!value.getTaxType().equals(taxType)) continue;
            return value.getSupportPeriod();
        }
        return null;
    }
}

