/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.enums;

import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;

public enum VoucherTypeEnum {
    WSPZ_YZF(SupplierEnum.YZF.getCode(), "wspz", "2"),
    SBB_YZF(SupplierEnum.YZF.getCode(), "sbbfile", "1"),
    SBB_ZWY(SupplierEnum.ZWY.getCode(), "sbbfile", "7"),
    WSPZ_ZWY(SupplierEnum.ZWY.getCode(), "wspz", "6");

    private String channel;
    private String taskType;
    private String voucherType;

    private VoucherTypeEnum(String channel, String taskType, String voucherType) {
        this.channel = channel;
        this.taskType = taskType;
        this.voucherType = voucherType;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getVoucherType() {
        return this.voucherType;
    }

    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType;
    }

    public static String getVoucherType(String channel, String taskType) {
        for (VoucherTypeEnum value : VoucherTypeEnum.values()) {
            if (!value.getTaskType().equalsIgnoreCase(taskType) || !value.getChannel().equalsIgnoreCase(channel)) continue;
            return value.getVoucherType();
        }
        return null;
    }

    public static String getVoucherType(SupplierEnum channel, ExecuteTypeEnums taskType) {
        String channelNumber = channel.getCode();
        String taskTypeKey = taskType.getKey();
        return VoucherTypeEnum.getVoucherType(channelNumber, taskTypeKey);
    }
}

