/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.enums.sbpzgl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.util.DateUtils;

public enum DeclareDateDisplayConditionsEnum {
    FIRST_CATEGORY(Arrays.asList(SupplierEnum.QXY, SupplierEnum.ZWY), Collections.singletonList(DeclareTypeEnum.YHS.getCode()), Collections.singletonList("single"));

    private List<SupplierEnum> suppliers;
    private List<String> declareTypes;
    private List<String> taxLimits;

    private DeclareDateDisplayConditionsEnum(List<SupplierEnum> suppliers, List<String> declareTypes, List<String> taxLimits) {
        this.suppliers = suppliers;
        this.declareTypes = declareTypes;
        this.taxLimits = taxLimits;
    }

    public List<SupplierEnum> getSuppliers() {
        return this.suppliers;
    }

    public List<String> getDeclareTypes() {
        return this.declareTypes;
    }

    public List<String> getTaxLimits() {
        return this.taxLimits;
    }

    public static boolean meetRules(SupplierEnum supplier, String declareTypeCode, Date skssqq, Date skssqz) {
        if (skssqq != null && skssqz != null) {
            String taxLimit = DateUtils.getTaxLimit(skssqq, skssqz);
            return DeclareDateDisplayConditionsEnum.meetRules(supplier, declareTypeCode, taxLimit);
        }
        return false;
    }

    public static boolean meetRules(SupplierEnum supplier, String declareTypeCode, String taxLimit) {
        for (DeclareDateDisplayConditionsEnum conditions : DeclareDateDisplayConditionsEnum.values()) {
            if (!conditions.getSuppliers().contains((Object)supplier)) continue;
            return true;
        }
        return false;
    }
}

