/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.ext.cloudcc.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpUtil.class);
    private static PoolingHttpClientConnectionManager poolConnManager = null;

    public static void init() {
        int maxTotalPool = 50;
        int maxConPerRoute = 5;
        int socketTimeout = 600000;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            SSLContext sslcontext = builder.build();
            HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            poolConnManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            poolConnManager.setMaxTotal(maxTotalPool);
            poolConnManager.setDefaultMaxPerRoute(maxConPerRoute);
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(socketTimeout).build();
            poolConnManager.setDefaultSocketConfig(socketConfig);
            if (poolConnManager.getTotalStats() != null) {
                logger.info("new client pool {}", (Object)poolConnManager.getTotalStats());
            }
        }
        catch (Exception e) {
            logger.error("InterfacePhpUtilManager init Exception {}", (Object)e.getMessage());
        }
    }

    public static CloseableHttpClient getConnection() {
        int connectionRequestTimeout = 1200000;
        int connectTimeout = 600000;
        int socketTimeout = 600000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        Map<String, String> configMap = CommonInfoUtil.getCommonConfigInfo();
        String proxy = configMap.get("kd_proxy");
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolConnManager);
        if (StringUtils.isNotEmpty((CharSequence)proxy)) {
            String[] values = proxy.trim().split(":");
            if (values.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"HttpUtil_0", (String)"taxc-tsate-common", (Object[])new Object[0]));
            }
            HttpHost httpHost = new HttpHost(values[0], Integer.parseInt(values[1]));
            httpClientBuilder.setProxy(httpHost);
        }
        CloseableHttpClient httpClient = httpClientBuilder.setDefaultRequestConfig(requestConfig).build();
        if (poolConnManager != null && poolConnManager.getTotalStats() != null) {
            logger.info("client pool info {}", (Object)poolConnManager.getTotalStats());
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> headers, HttpEntity httpEntity) {
        CloseableHttpClient client = HttpUtil.getConnection();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        String rs = "";
        try {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    post.setHeader(k, v);
                }
            } else {
                post.setHeader("Connection", "close");
            }
            post.setEntity(httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
                logger.info("\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c1" + rs);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        logger.info("\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c2" + rs);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doPost(String url, Map<String, String> headers, HttpEntity httpEntity, boolean isByte) {
        CloseableHttpClient client = HttpUtil.getConnection();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        byte[] rs = null;
        try {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    post.setHeader(k, v);
                }
            } else {
                post.setHeader("Connection", "close");
            }
            post.setEntity(httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                rs = EntityUtils.toByteArray((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
                logger.info("\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c1" + rs);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        logger.info("\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c2" + rs);
        return rs;
    }

    public static String doPost(String url, Map<String, Object> params) {
        return HttpUtil.doPost(url, null, params);
    }

    public static String doPostStream(String url, Map<String, String> headers, String body) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Accept", "application/json");
        logger.info("\u8bf7\u6c42url:" + url);
        logger.info("\u8bf7\u6c42body:" + body);
        return HttpUtil.doPost(url, headers, (HttpEntity)new ByteArrayEntity(body.getBytes()));
    }

    public static byte[] doPostJSON(String url, Map<String, String> headers, String jsonBody) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/json");
        logger.info("\u8bf7\u6c42url:" + url);
        logger.info("\u8bf7\u6c42body:" + jsonBody);
        return HttpUtil.doPost(url, headers, (HttpEntity)new ByteArrayEntity(jsonBody.getBytes()), true);
    }

    public static String doPost(String url, Map<String, String> headers, Map<String, Object> params) {
        if (params != null) {
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object obj = entry.getValue();
                urlParameters.add(new BasicNameValuePair(key, obj.toString()));
            }
            try {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Content-Type", "application/x-www-form-urlencoded");
                return HttpUtil.doPost(url, headers, (HttpEntity)new UrlEncodedFormEntity(urlParameters, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
        } else {
            try {
                return HttpUtil.doPost(url, null, (HttpEntity)new NullParamsHttpEntity());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    public static byte[] doPost(String url, Map<String, String> headers, Map<String, Object> params, boolean isByte) {
        if (params != null) {
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object obj = entry.getValue();
                urlParameters.add(new BasicNameValuePair(key, obj.toString()));
            }
            try {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Content-Type", "application/x-www-form-urlencoded");
                return HttpUtil.doPost(url, headers, (HttpEntity)new UrlEncodedFormEntity(urlParameters, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
        } else {
            try {
                return HttpUtil.doPost(url, null, (HttpEntity)new NullParamsHttpEntity(), true);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    static {
        HttpUtil.init();
    }

    private static class NullParamsHttpEntity
    extends StringEntity {
        public NullParamsHttpEntity() throws UnsupportedEncodingException {
            super("");
        }
    }
}

