/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.ext.cloudcc.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.taxc.tsate.common.ext.cloudcc.beans.UrlParams;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static Log logger = LogFactory.getLog(HttpUtils.class);
    private static PoolingHttpClientConnectionManager poolConnManager = null;

    public static void init() {
        int maxTotalPool = 50;
        int maxConPerRoute = 5;
        int socketTimeout = 600000;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            SSLContext sslcontext = builder.build();
            HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            poolConnManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            poolConnManager.setMaxTotal(maxTotalPool);
            poolConnManager.setDefaultMaxPerRoute(maxConPerRoute);
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(socketTimeout).build();
            poolConnManager.setDefaultSocketConfig(socketConfig);
            if (poolConnManager.getTotalStats() != null) {
                logger.info("new client pool {}", (Object)poolConnManager.getTotalStats());
            }
        }
        catch (Exception e) {
            logger.error("InterfacePhpUtilManager init Exception {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostAsString(String url, String data, Map<String, String> httpHeader, UrlParams urlParams) {
        String result = null;
        int responseStatusCode = 0;
        try {
            url = url + "?" + HttpUtils.buildUrlParams(urlParams);
            logger.info("\u8bf7\u6c42url:" + url);
            logger.info("\u62a5\u6587\u8f6c\u6362\uff1a" + data);
            logger.info("\u62a5\u6587\u8f6c\u63622\uff1a" + new String(data.getBytes()));
            CloseableHttpClient client = HttpUtils.getConnection();
            HttpPost request = new HttpPost(url);
            if (httpHeader != null) {
                for (Map.Entry<String, String> entry : httpHeader.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    request.setHeader(k, v);
                }
            } else {
                request.setHeader("Connection", "close");
            }
            logger.info("\u62a5\u6587\u6570\u636e\u662f\u5426\u4e3a\u7a7a\uff1a" + StringUtils.isNotBlank((String)data));
            if (StringUtils.isNotBlank((String)data)) {
                logger.info("\u62a5\u6587\u8f6c\u63623\uff1a" + new ByteArrayEntity(data.getBytes()));
                request.setEntity((HttpEntity)new ByteArrayEntity(data.getBytes()));
            }
            logger.info("\u8bbe\u7f6eContent-Type \u5f00\u59cb");
            request.setHeader("Content-Type", "application/octet-stream");
            logger.info("\u8bbe\u7f6eContent-Type \u7ed3\u675f");
            logger.info("httpReqUtils httpPostAsString\u8bf7\u6c42URL\uff1a" + url);
            CloseableHttpResponse response = (CloseableHttpResponse)client.execute((HttpUriRequest)request);
            responseStatusCode = response.getStatusLine().getStatusCode();
            logger.info("httpReqUtils httpPostAsString\u54cd\u5e94\u7801responseStatusCode\uff1a" + responseStatusCode);
            url = URLDecoder.decode(url, "UTF-8");
            if (responseStatusCode == 200) {
                try {
                    result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    logger.info("httpReqUtils httpPostAsString\u54cd\u5e94\uff1a" + result);
                }
                catch (Exception e) {
                    logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url + " " + e);
                }
            }
            logger.error("httpReqUtils httpPostAsString \u8fd4\u56de\u7ed3\u679c\uff1a[" + responseStatusCode + "]:" + result);
        }
        catch (Exception e) {
            logger.error("post\u8bf7\u6c42\u5904\u7406\u5931\u8d25:" + url + " " + e);
            logger.error("post\u8bf7\u6c42\u5904\u7406\u5931\u8d25:" + url + " " + e.getMessage());
        }
        finally {
            logger.error("httpReqUtils httpPostAsString \u8fd4\u56de\u7ed3\u679c\uff1a[" + responseStatusCode + "]:" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] httpPostAsByte(String url, String data, Map<String, String> httpHeader, UrlParams urlParams) {
        byte[] result = null;
        int responseStatusCode = 0;
        try {
            url = url + "?" + HttpUtils.buildUrlParams(urlParams);
            CloseableHttpClient client = HttpUtils.getConnection();
            HttpPost request = new HttpPost(url);
            if (httpHeader != null) {
                for (Map.Entry<String, String> entry : httpHeader.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    request.setHeader(k, v);
                }
            } else {
                request.setHeader("Connection", "close");
            }
            logger.info("\u62a5\u6587\u8f6c\u6362\uff1a" + data);
            if (StringUtils.isNotBlank((String)data)) {
                request.setEntity((HttpEntity)new ByteArrayEntity(data.getBytes()));
            }
            request.setHeader("Content-Type", "application/octet-stream");
            logger.info("httpReqUtils httpPostAsString\u8bf7\u6c42URL\uff1a" + url);
            CloseableHttpResponse response = (CloseableHttpResponse)client.execute((HttpUriRequest)request);
            responseStatusCode = response.getStatusLine().getStatusCode();
            url = URLDecoder.decode(url, "UTF-8");
            if (responseStatusCode == 200) {
                try {
                    result = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                }
                catch (Exception e) {
                    logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url + " " + e);
                }
            }
            logger.error("httpReqUtils httpPostAsString \u8fd4\u56de\u7ed3\u679c\uff1a[" + responseStatusCode + "]:" + result);
        }
        catch (Exception e) {
            logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url + " " + e);
        }
        finally {
            logger.error("httpReqUtils httpPostAsString \u8fd4\u56de\u7ed3\u679c\uff1a[" + responseStatusCode + "]:" + result);
        }
        return result;
    }

    public static String buildUrlParams(UrlParams urlParams) {
        Map<String, Object> paramMap = HttpUtils.bean2map(urlParams);
        StringBuilder stringBuilder = new StringBuilder();
        if (paramMap != null) {
            Iterator<Map.Entry<String, Object>> iterator = paramMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> item = iterator.next();
                stringBuilder.append(item.getKey()).append('=').append(item.getValue());
                if (!iterator.hasNext()) continue;
                stringBuilder.append('&');
            }
        }
        return stringBuilder.toString();
    }

    private static Map<String, Object> bean2map(Object bean) {
        try {
            PropertyDescriptor[] pds;
            TreeMap<String, Object> map = new TreeMap<String, Object>(Comparator.naturalOrder());
            BeanInfo b = Introspector.getBeanInfo(bean.getClass(), Object.class);
            for (PropertyDescriptor pd : pds = b.getPropertyDescriptors()) {
                String propertyName = pd.getName().substring(0, 1).toUpperCase() + pd.getName().substring(1);
                Method m = pd.getReadMethod();
                Object properValue = m.invoke(bean, new Object[0]);
                if (properValue == null) continue;
                map.put(propertyName, properValue);
            }
            return map;
        }
        catch (Exception e) {
            logger.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static CloseableHttpClient getConnection() {
        int connectionRequestTimeout = 1200000;
        int connectTimeout = 600000;
        int socketTimeout = 600000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        Map<String, String> configMap = CommonInfoUtil.getCommonConfigInfo();
        String proxy = configMap.get("kd_proxy");
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolConnManager);
        if (StringUtils.isNotEmpty((String)proxy)) {
            String[] values = proxy.trim().split(":");
            if (values.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"HttpUtils_0", (String)"taxc-tsate-common", (Object[])new Object[0]));
            }
            HttpHost httpHost = new HttpHost(values[0], Integer.parseInt(values[1]));
            httpClientBuilder.setProxy(httpHost);
        }
        CloseableHttpClient httpClient = httpClientBuilder.setDefaultRequestConfig(requestConfig).build();
        if (poolConnManager != null && poolConnManager.getTotalStats() != null) {
            logger.info("client pool info {}", (Object)poolConnManager.getTotalStats());
        }
        return httpClient;
    }

    static {
        HttpUtils.init();
    }
}

