/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.common.util.DateUtils;

public class CommonUtils {
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String SPLITSTRING = "#";
    private static final String ORGID = "org";
    private static final String STATUS = "declarestatus";
    private static final String PAY_STATUS = "paystatus";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SBRQ = "sbrq";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TEMPLATE_ID = "templateid";
    private static final String ID = "id";
    private static final String[] fields = new String[]{"id", "number", "contactinformation", "maincompany", "taxorg.taxpayer as taxpayer", "taxorg.unifiedsocialcode as unifiedsocialcode", "registertype.name", "registeredcapital", "registertime", "codeandname.name", "legalpeople", "registeraddress", "actualaddress", "accountingstandards", "orgid", "registeraddrdetail", "actualaddrdetail", "entryentity.bankname", "entryentity.bankacct,taxoffice"};

    public static Map<String, String> createYbnsr(String id, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        return CommonUtils.createYbnsr(id, null, type, orgId, startData, endData, isCreate, extendParams, templateId);
    }

    private static void set(Map<String, String> map, String key, String value) {
        map.put("tcvat_nsrxx#1#" + key, value);
    }

    public static Map<String, String> createYbnsr(String id, String billNo, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        HashMap<String, String> map = new HashMap<String, String>();
        CommonUtils.set(map, ORGID, orgId);
        CommonUtils.set(map, STATUS, "editing");
        CommonUtils.set(map, PAY_STATUS, "unpaid");
        CommonUtils.set(map, SKSSQQ, startData);
        CommonUtils.set(map, SKSSQZ, endData);
        CommonUtils.set(map, NSRTYPE, type);
        if (templateId != null) {
            CommonUtils.set(map, TEMPLATE_ID, String.valueOf(templateId));
        }
        CommonUtils.set(map, TAXLIMIT, DateUtils.getTaxLimit(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData)));
        CommonUtils.set(map, "ewblxh", "1");
        if (isCreate) {
            CommonUtils.set(map, "creator", RequestContext.get().getUserId());
            CommonUtils.set(map, "createtime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        }
        CommonUtils.set(map, "billstatus", "A");
        CommonUtils.set(map, "modifier", RequestContext.get().getUserId());
        CommonUtils.set(map, "modifytime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        CommonUtils.set(map, ID, id);
        CommonUtils.set(map, "billno", org.apache.commons.lang.StringUtils.isNotBlank((String)billNo) ? billNo : id);
        DynamicObjectCollection dcoll = QueryServiceHelper.query((String)"tctb_tax_main", (String)StringUtils.join((Object[])fields, (String)","), (QFilter[])new QFilter[]{new QFilter("taxorg.id", "=", (Object)Long.parseLong(orgId))});
        if (dcoll.size() > 0) {
            DynamicObjectCollection m;
            DynamicObject d;
            String actualaddress;
            CommonUtils.set(map, "taxauthority", ((DynamicObject)dcoll.get(0)).getString("taxoffice"));
            CommonUtils.set(map, "nsrsbh", ((DynamicObject)dcoll.get(0)).getString("unifiedsocialcode"));
            CommonUtils.set(map, "sshymc", ((DynamicObject)dcoll.get(0)).getString("codeandname.name"));
            CommonUtils.set(map, "nsrmc", ((DynamicObject)dcoll.get(0)).getString("taxpayer"));
            CommonUtils.set(map, "fddbrxm", ((DynamicObject)dcoll.get(0)).getString("legalpeople"));
            CommonUtils.set(map, "registertype", ((DynamicObject)dcoll.get(0)).getString("registertype.name"));
            CommonUtils.set(map, "zcdz", "");
            CommonUtils.set(map, "scjydz", "");
            CommonUtils.set(map, "phonenum", ((DynamicObject)dcoll.get(0)).getString("contactinformation"));
            String registeraddress = ((DynamicObject)dcoll.get(0)).getString("registeraddress");
            if (StringUtils.isNotEmpty((CharSequence)registeraddress)) {
                String registeraddrdetail = ((DynamicObject)dcoll.get(0)).getString("registeraddrdetail");
                CommonUtils.set(map, "zcdz", registeraddrdetail);
            }
            if (StringUtils.isNotEmpty((CharSequence)(actualaddress = ((DynamicObject)dcoll.get(0)).getString("actualaddress")))) {
                CommonUtils.set(map, "scjydz", ((DynamicObject)dcoll.get(0)).getString("actualaddrdetail"));
            }
            if (null != (d = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)dcoll.get(0)).get(ID), (String)"tctb_tax_main")) && null != (m = (DynamicObjectCollection)d.get("entryentity")) && m.size() > 0) {
                CommonUtils.set(map, "khyh", ((DynamicObject)m.get(0)).getString("bankname"));
                CommonUtils.set(map, "yhzh", ((DynamicObject)m.get(0)).getString("bankacct"));
            }
        }
        CommonUtils.set(map, "sblx", "1");
        CommonUtils.set(map, "serialno", "0");
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                CommonUtils.set(map, entry.getKey(), (String)entry.getValue());
            }
        }
        CommonUtils.set(map, "datatype", "1");
        return map;
    }

    public static Map<Long, List<Map<String, Object>>> buildInfoToMap(String groupKey, DynamicObjectCollection dataInfos, List<String> queryList) {
        HashMap<Long, List<Map<String, Object>>> map = new HashMap<Long, List<Map<String, Object>>>(16);
        if (dataInfos.isEmpty()) {
            return map;
        }
        Map<Long, List<DynamicObject>> groupByKey = dataInfos.stream().collect(Collectors.groupingBy(dataInfo -> dataInfo.getLong(groupKey)));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupByKey.entrySet()) {
            ArrayList infoList = new ArrayList(16);
            List<DynamicObject> entryValue = entry.getValue();
            for (DynamicObject dataInfo2 : entryValue) {
                HashMap<String, Object> info = new HashMap<String, Object>(16);
                for (String filed : queryList) {
                    info.put(filed, dataInfo2.get(filed));
                }
                infoList.add(info);
            }
            map.put(entry.getKey(), infoList);
        }
        return map;
    }

    public static Map<Long, List<DynamicObject>> buildInfoToMap(String groupKey, DynamicObjectCollection dataInfos) {
        Map<Long, List<DynamicObject>> groupByKey = new HashMap<Long, List<DynamicObject>>(16);
        if (dataInfos.isEmpty()) {
            return groupByKey;
        }
        groupByKey = dataInfos.stream().collect(Collectors.groupingBy(dataInfo -> dataInfo.getLong(groupKey)));
        return groupByKey;
    }
}

