/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.threadpools;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.taxc.tsate.common.threadpools.Task;

public class ThreadPoolsService {
    private static Log logger = LogFactory.getLog(ThreadPoolsService.class);
    private static ThreadPoolsService threadPoolsService = new ThreadPoolsService();
    private static ExecutorService dispatch = ThreadPools.newExecutorService((String)"threadPoolsService-dispatch-tsate", (int)4);
    private static ExecutorService ex = ThreadPools.newExecutorService((String)"threadPoolsService-tsate", (int)4);

    private ThreadPoolsService() {
    }

    public static ThreadPoolsService getInstance() {
        return threadPoolsService;
    }

    public Future<Future<Map<String, Object>>> submitCountFuture(Task call) {
        logger.info("\u7ebf\u7a0b\u5f00\u59cb\u6267\u884c:" + Thread.currentThread().getName());
        long time = System.currentTimeMillis();
        Future<Future<Map<String, Object>>> future = dispatch.submit(new ExecutorTaskCount(RequestContext.getOrCreate(), ex, call));
        logger.info("\u7ebf\u7a0b\u7ed3\u675f\u6267\u884c:" + Thread.currentThread().getName());
        logger.info("\u6267\u884c\u4efb\u52a1\u82b1\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return future;
    }

    static class ExecutorTaskCount
    implements Callable<Future<Map<String, Object>>> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Task call;

        public ExecutorTaskCount(RequestContext rc, ExecutorService ex, Task call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public Future<Map<String, Object>> call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            Future<Object> resultFuture = this.ex.submit(this.call.call(this.rc, null));
            return resultFuture;
        }
    }
}

