/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kd.taxc.tsate.common.util.EmptyCheckUtils;

public class BigDecimalUtil {
    public static BigDecimal divideObject(Object dec1, Object dec2, int scale) {
        return BigDecimalUtil.divideObject(dec1, dec2, scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (BigDecimalUtil.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).divide(BigDecimalUtil.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal stringToBigDecimal(String obj) {
        if (EmptyCheckUtils.isEmpty(obj)) {
            return null;
        }
        return new BigDecimal(obj);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().contains("e")) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    public static final String thousandth(Object num) {
        return DecimalFormat.getNumberInstance().format(BigDecimalUtil.toBigDecimal(num));
    }

    public static String format(Object num, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance());
        return format.format(num);
    }
}

