/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.lang.reflect.InvocationTargetException;
import kd.bos.dataentity.resource.ResManager;

public class ExceptionUtil {
    public static String toString(Exception e) {
        String title = e.getMessage();
        if (title == null || title.length() == 0) {
            title = e.getCause() != null ? e.getCause().toString() : e.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"ExceptionUtil_0", (String)"taxc-tsate-common", (Object[])new Object[]{title})).append("\n");
        StackTraceElement[] stack = ExceptionUtil.getTargetStack(e);
        if (stack == null || stack.length <= 0) {
            stack = ExceptionUtil.getExceptionStack(e);
        }
        sb.append(ExceptionUtil.stackTraceToString(stack));
        return sb.toString();
    }

    private static StackTraceElement[] getTargetStack(Throwable e) {
        InvocationTargetException invocateExe;
        Throwable throwa;
        if (e instanceof InvocationTargetException && (throwa = (invocateExe = (InvocationTargetException)e).getTargetException()) != null) {
            return throwa.getStackTrace();
        }
        return null;
    }

    private static StackTraceElement[] getExceptionStack(Throwable e) {
        return e.getStackTrace();
    }

    private static String stackTraceToString(StackTraceElement[] eles) {
        StringBuilder sb = new StringBuilder();
        if (eles != null) {
            int size = 0;
            for (StackTraceElement ele : eles) {
                if (size >= 100) {
                    int ignoreSize = eles.length - 100;
                    sb.append(ResManager.loadKDString((String)"\u7701\u7565\u5806\u6808\u6570\uff1a%s", (String)"ExceptionUtil_1", (String)"taxc-tsate-common", (Object[])new Object[]{ignoreSize}));
                    break;
                }
                String fileName = ele.getFileName();
                String className = ele.getClassName();
                String methodName = ele.getMethodName();
                int lineNumber = ele.getLineNumber();
                StringBuilder item = new StringBuilder();
                item.append("at ").append(className).append(".").append(methodName);
                item.append("(").append(fileName).append(":").append(lineNumber).append(")");
                sb.append((CharSequence)item).append("\n");
                ++size;
            }
        }
        return sb.toString();
    }
}

