/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class FileUploadUtils {
    private static final Log logger = LogFactory.getLog(FileUploadUtils.class);

    public static String upload(String storePath, String fileName, InputStream in) {
        logger.info("fileName:" + fileName);
        fileName = fileName.replaceAll("\\\\", "/");
        int index = -1;
        index = fileName.lastIndexOf(47);
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        try {
            storePath = FileUploadUtils.wrapPrefix(storePath);
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = new FileItem(fileName, storePath, in);
            fileService.delete(storePath);
            return fileService.upload(fileItem);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + storePath, (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static boolean uploadAttachment(String fileName, InputStream in, String formId, Object pkId, String appId) {
        return FileUploadUtils.uploadAttachment(fileName, in, formId, pkId, appId, null);
    }

    public static boolean uploadAttachment(String fileName, InputStream in, String formId, Object pkId, String appId, String originUrl) {
        logger.info("fileName:" + fileName);
        try {
            String tempUrl;
            int size = in.available();
            fileName = fileName.replaceAll("\\\\", "/");
            int index = -1;
            index = fileName.lastIndexOf(47);
            if (index != -1) {
                fileName = fileName.substring(index + 1);
            }
            if ((tempUrl = originUrl) == null) {
                tempUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 5000);
                tempUrl = RequestContext.getOrCreate().getClientFullContextPath() + EncreptSessionUtils.encryptSession((String)tempUrl);
            }
            HashMap attachmentMap = new HashMap();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", fileName);
            map.put("size", size);
            map.put("status", "success");
            map.put("uid", DB.genStringId((String)"bos_attachment"));
            map.put("url", tempUrl);
            map.put("entityNum", formId);
            map.put("client", "web");
            map.put("endProgress", true);
            attachmentMap.put("attachmentpanelap", Collections.singletonList(map));
            AttachmentServiceHelper.saveTempAttachments((String)formId, (Object)pkId, (String)appId, attachmentMap);
            return true;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Object)ExceptionUtil.toString(e));
            return false;
        }
    }

    public static List<String> getFilePaths(String formId, List<Object> pkIds, String attachKey, boolean enableTempAccess) {
        ArrayList<String> urls = new ArrayList<String>();
        for (Object pkId : pkIds) {
            List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey, (boolean)enableTempAccess);
            for (Map map : attachments) {
                urls.add((String)map.get("url"));
            }
        }
        return urls;
    }

    public static String extractFileName(String urlStr) {
        try {
            int startIndex = urlStr.indexOf("?path=") + "?path=".length();
            String path = urlStr.substring(startIndex);
            String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8.toString());
            String[] parts = decodedPath.split("/");
            String fileName = parts[parts.length - 1];
            String decodedFileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8.toString());
            return decodedFileName;
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString(e));
            return null;
        }
    }

    public static List<String> getFilePaths(String formId, List<String> pkIds, String attachKey) {
        ArrayList<String> urls = new ArrayList<String>();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bos_attachment", (String)"ffileid", (QFilter[])new QFilter[]{new QFilter("finterid", "in", pkIds).and(new QFilter("fbilltype", "=", (Object)formId).and("fattachmentpanel", "=", (Object)attachKey))});
        for (DynamicObject dyn : dyns) {
            String ffileid = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(dyn.getString("ffileid"));
            urls.add(ffileid);
        }
        return urls;
    }

    private static String wrapPrefix(String path) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String date = DateUtils.format(new Date(), "yyyyMMdd");
        StringBuilder prefix = new StringBuilder();
        prefix.append("/").append(tenantId).append("/").append(accountId).append("/").append(date);
        if (!path.startsWith(prefix.toString())) {
            prefix.append(path);
        }
        return prefix.toString();
    }

    public static String dealWithGatewayUrl(String urlStr, SupplierEnum supplier) {
        try {
            QFilter filter = new QFilter("key", "=", (Object)(supplier.getCode() + "_gateway_url"));
            DynamicObject obj = QueryServiceHelper.queryOne((String)"tsate_param_setting", (String)"key,value", (QFilter[])new QFilter[]{filter});
            if (obj == null || obj.getString("value") == null) {
                return urlStr;
            }
            String gatewayUrl = obj.getString("value");
            if (StringUtils.isEmpty((String)gatewayUrl)) {
                return urlStr;
            }
            URL originUrl = new URL(urlStr);
            if (gatewayUrl.endsWith("/")) {
                gatewayUrl = gatewayUrl.substring(0, gatewayUrl.length() - 1);
            }
            int subIndex = urlStr.indexOf(originUrl.getPath());
            String targetUrl = gatewayUrl + urlStr.substring(subIndex);
            logger.info("\u5df2\u53d8\u66f4\u4e3a\u7f51\u5173URL" + targetUrl);
            return targetUrl;
        }
        catch (MalformedURLException e) {
            logger.error(urlStr + " \u8f6c\u6362url\u5f02\u5e38");
            return urlStr;
        }
    }

    public static String getFileString(String fileUrl) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        InputStream inputStream = fileService.getInputStream(fileUrl);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, n);
            }
        }
        catch (Exception e) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e1) {
                return null;
            }
        }
        return outputStream.toString();
    }
}

