/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PageShowCommon;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.TreeUtils;

public class OrgUtils {
    private static final boolean DISABLED_FILTER = true;
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    public static List<Map<String, String>> queryOrgListForInitOrgComboItems(IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant) {
        DynamicObjectCollection collection;
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        HasPermOrgResult hasPermOrgResult = StringUtils.isBlank((CharSequence)permissionEntiyId) ? PermissionUtils.getAllPermOrgs(view) : PermissionUtils.getAllPermOrgs(view, permissionEntiyId, permissionConstant);
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            List<Long> orgList = hasPermOrgResult.getHasPermOrgs();
            HashMap<String, List<Object>> convertParam = new HashMap<String, List<Object>>(2);
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                orgList = OrgServiceHelper.mergeOrgIds(orgList, "3");
            }
            TreeUtils.convertParam("id", orgList, convertParam);
            collection = OrgServiceHelper.queryOrgListByCondition(convertParam);
        } else {
            collection = OrgServiceHelper.getOrgLists();
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            collection.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return orgItems;
    }

    public static List<Map<String, String>> queryOrgListForInitOrgComboItems(IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant, Boolean enable) {
        DynamicObjectCollection collection;
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        HasPermOrgResult hasPermOrgResult = StringUtils.isBlank((CharSequence)permissionEntiyId) ? PermissionUtils.getAllPermOrgs(view) : PermissionUtils.getAllPermOrgs(view, permissionEntiyId, permissionConstant);
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            List<Long> orgList = hasPermOrgResult.getHasPermOrgs();
            HashMap<String, List<Object>> convertParam = new HashMap<String, List<Object>>(2);
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                if (enable.booleanValue()) {
                    orgList = OrgServiceHelper.mergeOrgIds(orgList, "3");
                } else {
                    TreeUtils.convertParam("status", "1", convertParam);
                }
            }
            TreeUtils.convertParam("id", orgList, convertParam);
            collection = OrgServiceHelper.queryOrgListByCondition(convertParam);
        } else {
            collection = OrgServiceHelper.getOrgLists();
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            collection.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return orgItems;
    }

    public static List<ComboItem> getComboItems(List<Map<String, String>> orgList) {
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map<String, String> map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(map.get("name")));
            item.setValue(map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }
}

