/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.util.ExceptionUtil;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class ResourceUtils {
    static Log LOGGER = LogFactory.getLog(ResourceUtils.class);

    public static List<Class> scanClass(String classPath) {
        ArrayList<Class> list = new ArrayList<Class>(8);
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            StringBuilder resourcePath = new StringBuilder("classpath*:").append(classPath.replace(".", "/")).append("/*.class");
            for (Resource res : resources = resolver.getResources(resourcePath.toString())) {
                String clsName = new SimpleMetadataReaderFactory().getMetadataReader(res).getClassMetadata().getClassName();
                list.add(Class.forName(clsName));
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtil.toString(e));
        }
        return list;
    }

    public static List<Class> scanClassWithAnnotion(String classPath, Class annntionClass) {
        List<Class> list = ResourceUtils.scanClass(classPath);
        return list.stream().filter(clazz -> clazz.isAnnotationPresent(annntionClass)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String fileName) {
        ClassLoader classLoader = ResourceUtils.class.getClassLoader();
        BufferedReader reader = null;
        StringBuilder content = new StringBuilder();
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (urls != null && urls.hasMoreElements()) {
                URL url = urls.nextElement();
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtil.toString(e));
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(ExceptionUtil.toString(e));
            }
        }
        return content.toString();
    }
}

