/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.util.ExceptionUtil;
import org.springframework.util.Base64Utils;

public class RsaCryptTools {
    private static Log logger = LogFactory.getLog(RsaCryptTools.class);
    public static final String RSA = "RSA";
    private static final String ZWY_PUBLIC_KEY = "ZWY_PUBLIC_KEY";
    private static final String TAX_PRIVATE_KEY = "TAX_PRIVATE_KEY";
    private static final String QYX_PUBLIC_KEY = "QYX_PUBLIC_KEY";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 256;

    public static String getProperty(String key) {
        return RsaCryptTools.getSecretValue(key);
    }

    private static String getSecretValue(String key) {
        DynamicObject secretObj = BusinessDataServiceHelper.loadSingleFromCache((String)"tsate_secret_config", (String)"secretvalue_tag", (QFilter[])new QFilter[]{new QFilter("secretkey", "=", (Object)key)});
        if (secretObj != null) {
            return secretObj.getString("secretvalue_tag");
        }
        return null;
    }

    public static String qxyDataEncrypt(String data) {
        try {
            byte[] bytes = Base64.getDecoder().decode(RsaCryptTools.getProperty(QYX_PUBLIC_KEY));
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(RSA);
            PublicKey publicKey = factory.generatePublic(spec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(1, publicKey);
            int inputLen = data.getBytes().length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes(), offset, 117) : cipher.doFinal(data.getBytes(), offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return Base64Utils.encodeToString((byte[])encryptedData);
        }
        catch (Exception e) {
            logger.error("qxy \u53c2\u6570\u52a0\u5bc6\u51fa\u9519", (Object)ExceptionUtil.toString(e));
            return "";
        }
    }

    public static String encrypt(String data) {
        try {
            String taxPrivateKey = RsaCryptTools.getProperty(TAX_PRIVATE_KEY);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(taxPrivateKey));
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            int inputLen = 0;
            byte[] dataBytes = RsaCryptTools.compress(data.getBytes(StandardCharsets.UTF_8));
            if (null != dataBytes) {
                inputLen = dataBytes.length;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(dataBytes, offSet, 117) : cipher.doFinal(dataBytes, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            return Base64.getEncoder().encodeToString(encryptedData);
        }
        catch (Exception e) {
            logger.error("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String encryptByPrivateKey(String data) {
        try {
            String taxPrivateKey = RsaCryptTools.getProperty(TAX_PRIVATE_KEY);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(taxPrivateKey));
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            byte[] byteData = data.getBytes(StandardCharsets.UTF_8);
            int inputLen = byteData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(byteData, offSet, 117) : cipher.doFinal(byteData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            return Base64.getEncoder().encodeToString(encryptedData);
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String data) {
        try {
            String zwyPublicKey = RsaCryptTools.getProperty(ZWY_PUBLIC_KEY);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(zwyPublicKey));
            KeyFactory keyFactory = KeyFactory.getInstance(RSA);
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicKey);
            byte[] dataBytes = Base64.getDecoder().decode(data);
            int inputLen = dataBytes.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(dataBytes, offSet, 256) : cipher.doFinal(dataBytes, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 256;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return new String(decryptedData);
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u65f6\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static byte[] compress(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(data);
        gzip.close();
        return out.toByteArray();
    }
}

