/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.tsate.common.util.ByteUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class Sm4Util {
    public static final String SM4_ECB_PKCS5PADDING = "SM4/ECB/PKCS5Padding";
    public static final String SM4_ECB_PKCS7PADDING = "SM4/ECB/PKCS7Padding";
    public static final String SM4_CBC_PKCS5PADDING = "SM4/CBC/PKCS5Padding";
    private static final String SM4_DEFAULT_ENCODING = "UTF-8";
    private static final String SM4_DEFAULT_KEY = "6b8587ff4fea762933e29e39a7598ce4";

    public static String encryptEcb(String plainText) {
        return Sm4Util.encryptEcb(SM4_DEFAULT_KEY, plainText, SM4_ECB_PKCS5PADDING);
    }

    public static String encryptEcb(String key, String plainText, String padding) {
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)plainText) || StringUtils.isEmpty((CharSequence)padding)) {
            return null;
        }
        byte[] bs = Sm4Util.cipherSm4(ByteUtils.fromHexString(key), plainText.getBytes(Charset.forName(SM4_DEFAULT_ENCODING)), padding, null, 1);
        return Hex.toHexString((byte[])bs);
    }

    public static byte[] cipherSm4(byte[] key, byte[] text, String padding, byte[] ivPara, int opmode) {
        IvParameterSpec ivParameterSpec = null;
        Cipher cipher = null;
        byte[] ret = null;
        if (ivPara != null) {
            SecureRandom random = new SecureRandom();
            random.nextBytes(ivPara);
        }
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        if (ivPara != null) {
            ivParameterSpec = new IvParameterSpec(ivPara);
        }
        try {
            cipher = Cipher.getInstance(padding, "BC");
            cipher.init(opmode, (Key)sm4Key, ivParameterSpec);
            if (ivParameterSpec == null) {
                cipher.init(opmode, sm4Key);
            } else {
                cipher.init(opmode, (Key)sm4Key, ivParameterSpec);
            }
            ret = cipher.doFinal(text);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4f7f\u7528SM4\u8fdb\u884c\u52a0\u3001\u89e3\u5bc6\u51fa\u73b0\u5f02\u5e38\uff01", (String)"Sm4Util_0", (String)"taxc-tsate-common", (Object[])new Object[0]), e);
        }
        return ret;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

