/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.common.util.ExceptionUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlUtil {
    private static Log logger = LogFactory.getLog(XmlUtil.class);

    public static Object parseElement(Element ele) {
        Attribute type = ele.attribute("type");
        if (type != null && "list".equals(type.getValue())) {
            ArrayList<Object> list = new ArrayList<Object>(8);
            XmlUtil.sortChild(ele);
            for (Element child : ele.elements()) {
                list.add(XmlUtil.parseElement(child));
            }
            return list;
        }
        if (type != null && "map".equals(type.getValue())) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(8);
            for (Element child : ele.elements()) {
                map.put(child.getName(), XmlUtil.parseElement(child));
            }
            return map;
        }
        return XmlUtil.dataTranslate(ele);
    }

    public static Object parseXmlString(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            return XmlUtil.parseElement(doc.getRootElement());
        }
        catch (DocumentException e) {
            logger.error("parseXmlString error:{}", (Object)ExceptionUtil.toString((Exception)((Object)e)));
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790xml\u5f02\u5e38", (String)"XmlUtil_1", (String)"taxc-tsate-common", (Object[])new Object[0]));
        }
    }

    public static Object dataTranslate(Element ele) {
        String text = ele.getText();
        Attribute type = ele.attribute("type");
        if (StringUtil.isEmpty((CharSequence)text)) {
            return text;
        }
        if (type != null) {
            String datatype = type.getValue();
            if (datatype.contains("number")) {
                return XmlUtil.parseNumber(datatype, text);
            }
            if (datatype.contains("boole")) {
                return XmlUtil.parseBoolean(text);
            }
        }
        return text;
    }

    private static Boolean parseBoolean(String text) {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        if ("1".equals(text)) {
            return true;
        }
        if ("0".equals(text)) {
            return false;
        }
        return Boolean.parseBoolean(text);
    }

    private static BigDecimal parseNumber(String dataType, String text) {
        try {
            String[] nStr = dataType.split("\\|");
            int scale = -1;
            int roundmode = -1;
            if (nStr.length > 1) {
                scale = Integer.parseInt(nStr[1]);
            }
            if (nStr.length > 2) {
                roundmode = Integer.parseInt(nStr[2]);
            }
            BigDecimal number = new BigDecimal(text);
            if (roundmode != -1) {
                return number.setScale(scale, roundmode);
            }
            if (scale != -1) {
                return number.setScale(scale);
            }
            return number;
        }
        catch (Exception e) {
            logger.error("parse xml number failed,detail:" + ExceptionUtil.toString(e));
            return null;
        }
    }

    private static void sortChild(Element ele) {
        String[] params;
        Attribute sort = ele.attribute("sort");
        if (sort == null) {
            return;
        }
        String sorKey = null;
        String[] locationValue = new String[]{};
        String str = sort.getValue();
        for (String paramStr : params = str.split(";")) {
            String[] kv = paramStr.split("=");
            String k = kv[0];
            String v = kv[1];
            if ("key".equals(k)) {
                sorKey = v;
                continue;
            }
            if (!"location".equals(k)) continue;
            locationValue = v.split(",");
        }
        List list = ele.elements();
        if (locationValue.length > 0) {
            final HashMap<String, Integer> locationValueIndex = new HashMap<String, Integer>(8);
            for (int i = 0; i < locationValue.length; ++i) {
                locationValueIndex.put(locationValue[i], i);
            }
            final String compareKey = sorKey;
            list.sort(new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    int weight1 = -1;
                    Element childFild1 = o1.element(compareKey);
                    if (childFild1 != null) {
                        String text1 = childFild1.getText();
                        weight1 = (Integer)locationValueIndex.get(text1);
                    }
                    int weight2 = -1;
                    Element childFild2 = o2.element(compareKey);
                    if (childFild2 != null) {
                        String text2 = childFild2.getText();
                        weight2 = (Integer)locationValueIndex.get(text2);
                    }
                    return weight1 - weight2;
                }
            });
            for (Element child : list) {
                ele.remove(child);
            }
            for (Element child : list) {
                ele.add(child);
            }
        }
    }
}

