/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util.servicehelperutils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import org.apache.commons.lang.StringUtils;

public class ServiceHelperBaseUtils {
    private static Log logger = LogFactory.getLog(ServiceHelperBaseUtils.class);

    public static boolean checkTaxResult(TaxResult result) {
        return result.isSuccess() && StringUtils.equals((String)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (String)result.getCode());
    }

    public static boolean checkTaxResultByCode(TaxResult result, String code) {
        return result.isSuccess() && StringUtils.equals((String)code, (String)result.getCode());
    }

    public static void checkTaxResultAndThrowEx(TaxResult result) {
        if (!ServiceHelperBaseUtils.checkTaxResult(result)) {
            logger.info("isSuccess={},errorCode={} message={}", new Object[]{result.isSuccess(), result.getCode(), result.getMessage()});
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u65f6\u5931\u8d25\uff1a%s", (String)"ServiceHelperBaseUtils_0", (String)"taxc-tsate-common", (Object[])new Object[]{result.getMessage()}));
        }
    }

    public static void checkTaxResultAndThrowEx(TaxResult result, String mesg) {
        if (!ServiceHelperBaseUtils.checkTaxResult(result)) {
            logger.info("isSuccess={},errorCode={} message={}", new Object[]{result.isSuccess(), result.getCode(), mesg});
            throw new KDBizException(mesg + result.getMessage());
        }
    }

    public static void logTaxResultInfo(TaxResult result, String serviceMsg) {
        logger.info("serviceMsg ={} isSuccess={},errorCode={} msg={}", new Object[]{serviceMsg, result.isSuccess(), result.getCode(), result.getMessage()});
    }

    public static void checkTaxResultAndThrowEx(TaxResult result, String successCode, String mesg) {
        if (!ServiceHelperBaseUtils.checkTaxResultByCode(result, successCode)) {
            logger.info("isSuccess={},errorCode={} msg={}", new Object[]{result.isSuccess(), result.getCode(), mesg});
            throw new KDBizException(mesg + result.getMessage());
        }
    }
}

