/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util.template;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.metadata.domain.EntityField;
import kd.taxc.tsate.common.metadata.domain.EntityInfo;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;

public class TemplateUtils {
    public static final String EWBLXH = "ewblxh";
    public static final String SPLIT_STRING_SAVE = "#";
    public static final String SPLIT_STRING_SHOW = "_";
    public static final int TAXRATE_EXPANDED_TIMES = 100;
    public static final BigDecimal DEFAULT_VALUE = new BigDecimal("0.00");
    public static final BigDecimal COMPARE_STANDARD_VALUE = new BigDecimal("1.00");
    public static final Pattern FIELDNAME_Pattern = Pattern.compile("[\\[\\]()\uff08\uff09\"\u201c\u201d/]");
    public static final String DEFAULT_DECIMAL_FORMAT = "#####0.00";
    public static final String DECIMAL_INIT_FORMAT = "#####0";
    public static final String MICROMETER_DECIMAL_INIT_FORMAT = "###,##0";
    public static final int GET_TEMPLATE_MODEL_START = 1;
    public static final int GET_TEMPLATE_MODEL_END = 0;
    private static final Set<String> BASE_FIELD_LAST = new HashSet<String>();
    private static final String TCVAT_NSRXX_EWBLXH = "tcvat_nsrxx#1#ewblxh";
    private static final String TCVAT_NSRXX_MODIFYTIME = "tcvat_nsrxx#1#modifytime";
    private static final String TCVAT_NSRXX_MODIFIER = "tcvat_nsrxx#1#modifier";
    private static final String TCVAT_NSRXX_BQYBTSE = "tcvat_nsrxx#1#bqybtse";
    private static final String TCVAT_SB_FJSF_BQYBSE = "tcvat_sb_fjsf#9#bqybse";

    public static Set<String> getBaseFieldLast() {
        return BASE_FIELD_LAST;
    }

    public static Map<String, String> dataToMap(String entityId, String spitStr, QFilter[] filters) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        EntityInfo entityInfo = MetadataUtil.getEntityById(entityId);
        String allFieldToQuery = MetadataUtil.getAllFieldString(entityId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)allFieldToQuery, (QFilter[])filters);
        if (collection == null || collection.isEmpty()) {
            return dataMap;
        }
        for (DynamicObject dObject : collection) {
            String ewbxh = dObject.getString(EWBLXH);
            for (EntityField field : entityInfo.getFieldList()) {
                if ("entryentity".equals(field.getFieldId()) || !dObject.containsProperty(field.getFieldId())) continue;
                Object obj = dObject.get(field.getFieldId());
                String key = entityId + spitStr + ewbxh + spitStr + field.getFieldId();
                if (obj == null) continue;
                dataMap.put(key, TemplateUtils.dataFormatPreSave(obj, field));
            }
        }
        return dataMap;
    }

    public static void dealData(String spitStr, Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            String[] splitKey = key.split(spitStr);
            EntityInfo entityInfo = MetadataUtil.getEntityById(splitKey[0]);
            for (EntityField entityField : entityInfo.getFieldList()) {
                String fieldId = splitKey[2];
                String fieldType = entityField.getFieldType();
                if (!fieldId.equals(entityField.getFieldId())) continue;
                if ("Decimal".equals(entityField.getFieldType()) || "Amount".equals(entityField.getFieldType())) {
                    try {
                        BigDecimal bd = EmptyCheckUtils.isNotEmpty(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue()) ? new BigDecimal(entry.getValue().toString()) : new BigDecimal("0.00");
                        DecimalFormat decimalFormat = new DecimalFormat(TemplateUtils.getDecimalFormatByMetadataScale(entityField, DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                        entry.setValue(decimalFormat.format(bd));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("DateTime".equals(fieldType)) {
                    if (EmptyCheckUtils.isNotEmpty(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue())) {
                        entry.setValue(DateUtils.format(DateUtils.stringToDate((String)entry.getValue()), "yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    entry.setValue(null);
                    continue;
                }
                if ("Date".equals(fieldType)) {
                    if (EmptyCheckUtils.isNotEmpty(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue())) {
                        entry.setValue(DateUtils.format(DateUtils.stringToDate((String)entry.getValue()), "yyyy-MM-dd"));
                        continue;
                    }
                    entry.setValue(null);
                    continue;
                }
                if ("Long".equals(fieldType)) {
                    if (!EmptyCheckUtils.isEmpty(entry.getValue()) && !"0.00".equals(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue())) continue;
                    entry.setValue("0");
                    continue;
                }
                if ("Integer".equals(fieldType)) {
                    if (!EmptyCheckUtils.isEmpty(entry.getValue()) && !"0.00".equals(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue())) continue;
                    entry.setValue("0");
                    continue;
                }
                if ("Basedata".equals(fieldType)) {
                    if (!EmptyCheckUtils.isEmpty(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue())) continue;
                    entry.setValue("0");
                    continue;
                }
                if (!EmptyCheckUtils.isEmpty(entry.getValue()) && !"\u2500\u2500".equals(entry.getValue())) continue;
                entry.setValue("");
            }
        }
    }

    public static String dataFormatPreSave(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("Decimal".equals(fieldType.getFieldType()) || "Amount".equals(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    DecimalFormat decimalFormat = new DecimalFormat(TemplateUtils.getDecimalFormatByMetadataScale(fieldType, DECIMAL_INIT_FORMAT, DEFAULT_DECIMAL_FORMAT));
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "DateTime".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd HH:mm:ss");
            }
            if (dataObj instanceof Date && "Date".equals(fieldType.getFieldType())) {
                return DateUtils.format((Date)dataObj, "yyyy-MM-dd");
            }
        }
        return dataObj.toString();
    }

    public static String getDecimalFormatByMetadataScale(EntityField fieldType, String initFormat, String defaultDecimalFormat) {
        if (null != fieldType) {
            StringBuilder format = new StringBuilder(initFormat);
            int scale = fieldType.getScale();
            for (int i = 0; i < scale; ++i) {
                if (i == 0) {
                    format.append('.');
                }
                format.append('0');
            }
            return format.toString();
        }
        return defaultDecimalFormat;
    }

    static {
        BASE_FIELD_LAST.add("id");
        BASE_FIELD_LAST.add(EWBLXH);
        BASE_FIELD_LAST.add("ewblname");
        BASE_FIELD_LAST.add("sbbid");
    }
}

