/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.common.util.template;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.tsate.common.enums.taxtype.ErroTaxCategoryEnum;
import org.apache.commons.lang.StringEscapeUtils;

public class VmTemplateCommonUtils {
    private static final String ZERO_PREFIX = "00";
    private static final String TAXC_CLOUD_ID = "taxc";
    private static Log logger = LogFactory.getLog(VmTemplateCommonUtils.class);

    public static String setJmxzdmDobuleZeroPrefix(String jmxzdm) {
        if (StringUtils.isBlank((CharSequence)jmxzdm)) {
            return "";
        }
        if (jmxzdm.length() > 8) {
            return jmxzdm;
        }
        return ZERO_PREFIX + jmxzdm;
    }

    public static String splitJmxzDm(String jmxzdm) {
        if (StringUtils.isBlank((CharSequence)jmxzdm)) {
            return "";
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(jmxzdm);
        if (m.find()) {
            return VmTemplateCommonUtils.setJmxzdmDobuleZeroPrefix(m.group());
        }
        return "";
    }

    public static String splitJmxzMc(String jmxzdm) {
        if (StringUtils.isBlank((CharSequence)jmxzdm)) {
            return "";
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(jmxzdm);
        if (m.find()) {
            return jmxzdm.substring(m.group().length());
        }
        return "";
    }

    public static String getJmxzdmKeepDigit(String jmxzdm, int digit) {
        if (StringUtils.isBlank((CharSequence)jmxzdm)) {
            return "";
        }
        return jmxzdm.substring(jmxzdm.length() - digit);
    }

    public static String errorZsxmConversion(String zsxm) {
        String sysName = ErroTaxCategoryEnum.getSysNameByTaxNames(zsxm);
        if (sysName == null) {
            return zsxm;
        }
        return sysName;
    }

    public static String escapeXml(String data) {
        return StringEscapeUtils.escapeXml((String)data);
    }

    public static Object invokeTdmTaxcBizService(String serviceName, String methodName, Object ... paras) {
        return DispatchServiceHelper.invokeBizService((String)TAXC_CLOUD_ID, (String)"tdm", (String)serviceName, (String)methodName, (Object[])paras);
    }

    public static Object invokeTpoTaxcBizService(String serviceName, String methodName, Object ... paras) {
        try {
            Object singleObj = DispatchServiceHelper.invokeBizService((String)TAXC_CLOUD_ID, (String)"tpo", (String)serviceName, (String)methodName, (Object[])paras);
            return singleObj;
        }
        catch (Exception e) {
            logger.error("appId:{},serviceName:{},methodName:{},paras:{}", new Object[]{"tpo", serviceName, methodName, paras});
            logger.error((Throwable)e);
            return "";
        }
    }
}

