/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.business.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.ttc.TtcValueRulesSceneidEnum;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class ValueRulesBusiness {
    public static List<TtcValueRulesSceneidEnum> getTtcValueRulesSceneidEnum(IDataModel model) {
        DynamicObjectCollection collection = model.getDataEntity().getDynamicObjectCollection("sceneid");
        ArrayList<TtcValueRulesSceneidEnum> list = new ArrayList<TtcValueRulesSceneidEnum>();
        if (null != collection) {
            boolean isIncludeDefault = false;
            for (DynamicObject dynamicObject : collection) {
                String sceneNumber = dynamicObject.getString("fbasedataid.number");
                TtcValueRulesSceneidEnum ttcValueRulesSceneidEnum2 = TtcValueRulesSceneidEnum.getEnumBySceneNumber((String)sceneNumber);
                list.add(ttcValueRulesSceneidEnum2);
                if (!StringUtil.equalsIgnoreCase((CharSequence)ttcValueRulesSceneidEnum2.getSceneNumber(), (CharSequence)TtcValueRulesSceneidEnum.DEFAULT.getSceneNumber())) continue;
                isIncludeDefault = true;
            }
            if (isIncludeDefault && list.size() > 1) {
                list.removeIf(ttcValueRulesSceneidEnum -> StringUtil.equalsIgnoreCase((CharSequence)ttcValueRulesSceneidEnum.getSceneNumber(), (CharSequence)TtcValueRulesSceneidEnum.DEFAULT.getSceneNumber()));
            }
        }
        return list;
    }

    public static Map<String, Map<String, Map<String, List<String>>>> queryTargetValuesBySourceValue(Long orgId, Long taxationSysId, Long sceneId, List<String> sourceValueList) {
        HashMap<String, Map<String, Map<String, List<String>>>> sourceTargetMap = new HashMap<String, Map<String, Map<String, List<String>>>>();
        if (null == orgId || null == taxationSysId || null == sceneId || null == sourceValueList) {
            return sourceTargetMap;
        }
        QFilter idQ = QFilter.isNotNull((String)"id").and("taxationsysid", "=", (Object)taxationSysId).and("sceneid.fbasedataid", "=", (Object)sceneId);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"ttc_valuerules", (Long)orgId, (QFilter)idQ, (String)"id,basicdatatype,valuerules_entry,taxationsysid,sourcetype,targettype,targetobjectid,sceneid,valuerules_entry.basicdatanumber,valuerules_entry.basicdata,valuerules_entry.targetnumber,valuerules_entry.targetname,valuerules_entry.sourcevalue,valuerules_entry.targetvalue");
        for (DynamicObject row : collection) {
            HashMap<String, String> sourceTargetValueMap = new HashMap<String, String>();
            String sourceType = row.getString("sourcetype");
            String targetType = row.getString("targettype");
            String targetObjectId = row.getString("targetobjectid");
            if (StringUtil.equalsIgnoreCase((CharSequence)sourceType, (CharSequence)"basedata")) {
                if (StringUtil.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"basedata")) {
                    sourceTargetValueMap.put(row.getString("valuerules_entry.sourcevalue"), row.getString("valuerules_entry.targetvalue"));
                } else if (StringUtil.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"text")) {
                    targetObjectId = "text";
                    sourceTargetValueMap.put(row.getString("valuerules_entry.sourcevalue"), row.getString("valuerules_entry.targetname"));
                }
            } else if (StringUtil.equalsIgnoreCase((CharSequence)sourceType, (CharSequence)"text")) {
                if (StringUtil.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"basedata")) {
                    sourceTargetValueMap.put(row.getString("valuerules_entry.basicdata"), row.getString("valuerules_entry.targetvalue"));
                } else if (StringUtil.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"text")) {
                    targetObjectId = "text";
                    sourceTargetValueMap.put(row.getString("valuerules_entry.basicdata"), row.getString("valuerules_entry.targetname"));
                }
            }
            for (Map.Entry entry : sourceTargetValueMap.entrySet()) {
                ArrayList list;
                Map entryTargetValueMap;
                Map targetTypeValueMap;
                if (!sourceValueList.contains(entry.getKey())) continue;
                if (sourceTargetMap.containsKey(entry.getKey())) {
                    targetTypeValueMap = (Map)sourceTargetMap.get(entry.getKey());
                    if (targetTypeValueMap.containsKey(targetType)) {
                        entryTargetValueMap = (Map)targetTypeValueMap.get(targetType);
                        if (entryTargetValueMap.containsKey(targetObjectId)) {
                            ((List)entryTargetValueMap.get(targetObjectId)).add(entry.getValue());
                            continue;
                        }
                        list = new ArrayList();
                        list.add(entry.getValue());
                        entryTargetValueMap.put(targetObjectId, list);
                        continue;
                    }
                    entryTargetValueMap = new HashMap();
                    list = new ArrayList();
                    list.add(entry.getValue());
                    entryTargetValueMap.put(targetObjectId, list);
                    targetTypeValueMap.put(targetType, entryTargetValueMap);
                    continue;
                }
                targetTypeValueMap = new HashMap();
                entryTargetValueMap = new HashMap();
                list = new ArrayList();
                list.add(entry.getValue());
                entryTargetValueMap.put(targetObjectId, list);
                targetTypeValueMap.put(targetType, entryTargetValueMap);
                sourceTargetMap.put((String)entry.getKey(), targetTypeValueMap);
            }
        }
        return sourceTargetMap;
    }
}

