/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.business.taxcode.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.taxc.ttc.business.taxcode.TaxRuleAlgoBusiness;
import kd.taxc.ttc.business.taxcode.TaxRuleBusiness;
import kd.taxc.ttc.common.util.transactiontax.ObjectQueryUtils;
import kd.taxc.ttc.common.vo.transactiontax.BillTaxVo;
import kd.taxc.ttc.common.vo.transactiontax.FourPVo;

public class TaxRuleBusinessImpl
implements TaxRuleBusiness {
    private String entryclass = "entryclass";
    private String entrytype = "entrytype";
    private String condition = "condition";
    private String valueid = "valueid";
    private String administrativelevel = "administrativelevel";
    private String link = "link";
    private String itemclass = "itemclass";
    private String itemresult = "itemresult";
    private String number = "number";
    private String select = "id,taxsystem,taxtype," + this.number + "," + this.itemclass + "," + this.itemresult + ",entryentity." + this.entryclass + ",entryentity." + this.entrytype + ", entryentity." + this.condition + ",entryentity." + this.valueid + ",entryentity." + this.link + ",entryentity.valuename,entryentity." + this.administrativelevel + ", entryentity1,entryentity1.taxcodenumber";

    @Override
    public List<TaxLineVo> service(BillTaxVo billTaxVo, List<FourPVo> fourP) {
        ArrayList<TaxLineVo> taxLineVos = new ArrayList<TaxLineVo>(16);
        long size = 0L;
        DynamicObject ret = null;
        try (DataSet dataSet = TaxRuleAlgoBusiness.handlerFourPVo(fourP);){
            DynamicObject[] dos = ObjectQueryUtils.queryBdtaxrTaxRules(this.select, billTaxVo.getOrgId(), billTaxVo.getCountry(), billTaxVo.getDate(), billTaxVo.getTaxationsys(), billTaxVo.getTaxType());
            billTaxVo.getLogger().addTaxRule(dos);
            billTaxVo.getTaxLogMaterialLineDto().collectTaxRules(dos);
            for (DynamicObject dd : dos) {
                boolean flag = true;
                DynamicObjectCollection entry = dd.getDynamicObjectCollection("entryentity");
                for (DynamicObject v : entry) {
                    String filter = this.createFilter(v);
                    DataSet copyDataSet = dataSet.copy();
                    Throwable throwable = null;
                    try {
                        DataSet temDataSet = copyDataSet.filter(filter);
                        Throwable throwable2 = null;
                        try {
                            if (!temDataSet.isEmpty()) continue;
                            billTaxVo.getLogger().addTaxRule(dd.getString("number"), filter);
                            flag = false;
                            break;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (temDataSet == null) continue;
                            if (throwable2 != null) {
                                try {
                                    temDataSet.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            temDataSet.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (copyDataSet == null) continue;
                        if (throwable != null) {
                            try {
                                copyDataSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        copyDataSet.close();
                    }
                }
                if (!flag || size >= (long)entry.size()) continue;
                size = entry.size();
                ret = dd;
            }
        }
        if (null != ret) {
            billTaxVo.getLogger().addTaxRule(ret);
            billTaxVo.getTaxLogMaterialLineDto().collectLastTaxRule(ret);
            ArrayList<Long> taxCodeList = new ArrayList<Long>(16);
            DynamicObjectCollection taxCodeCollection = ret.getDynamicObjectCollection("entryentity1");
            taxCodeList.addAll(taxCodeCollection.stream().map(o -> o.getLong("taxcodenumber.id")).collect(Collectors.toList()));
            this.singleTaxCode(taxLineVos, taxCodeList, billTaxVo, 1);
            if (!ObjectUtils.isEmpty(taxLineVos)) {
                billTaxVo.getAtomicInteger().getAndIncrement();
            }
        }
        billTaxVo.getLogger().addTaxCodeAndTaxRate(taxLineVos);
        billTaxVo.getTaxLogMaterialLineDto().collectTaxLineVos(taxLineVos);
        return taxLineVos;
    }

    @Override
    public List<String> service(BillTaxVo billTaxVo, List<FourPVo> fourP, String newjk) {
        ArrayList<String> taxCodeList = new ArrayList<String>(16);
        try (DataSet dataSet = TaxRuleAlgoBusiness.handlerFourPVo(fourP);){
            DynamicObject[] dos = ObjectQueryUtils.queryBdtaxrTaxRules(this.select, billTaxVo.getOrgId(), billTaxVo.getCountry(), billTaxVo.getDate(), billTaxVo.getTaxationsys(), billTaxVo.getTaxType());
            billTaxVo.getLogger().addTaxRule(dos);
            long size = 0L;
            DynamicObject ret = null;
            for (DynamicObject dd : dos) {
                boolean flag = true;
                DynamicObjectCollection entry = dd.getDynamicObjectCollection("entryentity");
                for (DynamicObject v : entry) {
                    String filter = this.createFilter(v);
                    DataSet tempDataSet = dataSet.copy();
                    Throwable throwable = null;
                    try {
                        DataSet lastDataSet = tempDataSet.filter(filter);
                        Throwable throwable2 = null;
                        try {
                            if (!lastDataSet.isEmpty()) continue;
                            billTaxVo.getLogger().addTaxRule(dd.getString("number"), filter);
                            flag = false;
                            break;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (lastDataSet == null) continue;
                            if (throwable2 != null) {
                                try {
                                    lastDataSet.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            lastDataSet.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (tempDataSet == null) continue;
                        if (throwable != null) {
                            try {
                                tempDataSet.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        tempDataSet.close();
                    }
                }
                if (!flag || size >= (long)entry.size()) continue;
                size = entry.size();
                ret = dd;
            }
            if (null != ret) {
                billTaxVo.getLogger().addTaxRule(ret);
                DynamicObjectCollection taxCodeCollection = ret.getDynamicObjectCollection("entryentity1");
                taxCodeList.addAll(taxCodeCollection.stream().map(o -> o.getString("taxcodenumber.number")).collect(Collectors.toList()));
            }
        }
        return taxCodeList;
    }

    @Override
    public DynamicObject[] batchServiceByOrgAndTaxationsys(BillTaxVo billTaxVo) {
        return ObjectQueryUtils.queryBdtaxrTaxRules(this.select, billTaxVo.getOrgId(), billTaxVo.getCountry(), billTaxVo.getDate(), billTaxVo.getTaxationsys(), billTaxVo.getTaxTypeList());
    }

    @Override
    public Map<String, List<String>> batchService(DynamicObject[] dynamicObjects, List<List<FourPVo>> allFourPVoList) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(16);
        if (!ObjectUtils.isEmpty((Object[])dynamicObjects) && !ObjectUtils.isEmpty(allFourPVoList)) {
            allFourPVoList.stream().forEach(fourPVos -> {
                ArrayList taxCodeList = new ArrayList(16);
                try (DataSet dataSet = TaxRuleAlgoBusiness.handlerFourPVo(fourPVos);){
                    long size = 0L;
                    DynamicObject ret = null;
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        boolean flag = true;
                        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
                        for (DynamicObject v : entry) {
                            String filter = this.createFilter(v);
                            DataSet tempDataSet = dataSet.copy();
                            Throwable throwable = null;
                            try {
                                DataSet lastDataSet = tempDataSet.filter(filter);
                                Throwable throwable2 = null;
                                try {
                                    if (!lastDataSet.isEmpty()) continue;
                                    flag = false;
                                    break;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (lastDataSet == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            lastDataSet.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    lastDataSet.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (tempDataSet == null) continue;
                                if (throwable != null) {
                                    try {
                                        tempDataSet.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                tempDataSet.close();
                            }
                        }
                        if (!flag || size >= (long)entry.size()) continue;
                        size = entry.size();
                        ret = dynamicObject;
                    }
                    if (null != ret) {
                        DynamicObjectCollection entry = ret.getDynamicObjectCollection("entryentity");
                        String valueid = "0";
                        for (DynamicObject v : entry) {
                            if (!"1036241275604686848".equals(v.getString("entrytype.id"))) continue;
                            valueid = v.getString("valueid");
                            break;
                        }
                        DynamicObjectCollection taxCodeCollection = ret.getDynamicObjectCollection("entryentity1");
                        taxCodeList.addAll(taxCodeCollection.stream().map(o -> o.getString("taxcodenumber.number")).collect(Collectors.toList()));
                        String taxsystemId = ret.getString("taxsystem.id");
                        String taxtypeId = ret.getString("taxtype.id");
                        String mapkey = taxsystemId + "_" + taxtypeId + "_" + valueid;
                        if (!resultMap.containsKey(mapkey)) {
                            resultMap.put(mapkey, new ArrayList());
                        }
                        ((List)resultMap.get(mapkey)).addAll(taxCodeList);
                    }
                }
            });
        }
        return resultMap;
    }

    private String createFilter(DynamicObject dd) {
        StringBuilder sb = new StringBuilder();
        String entryClass = dd.getString(this.entryclass);
        sb.append(" entryClass = \"").append(entryClass).append('\"');
        DynamicObject d = dd.getDynamicObject(this.entrytype);
        long entryType = 0L;
        if (null != d) {
            entryType = dd.getDynamicObject(this.entrytype).getLong("id");
        }
        sb.append(" and entryType = ").append(entryType);
        String value = dd.getString(this.valueid);
        String conditions = dd.getString(this.condition);
        if (conditions.contains("in")) {
            sb.append(" and valueId ").append(conditions).append('(').append(value).append(')');
        } else {
            sb.append(" and valueId ").append(conditions).append(value);
        }
        sb.append(" and administrativelevel = \"").append(dd.getString(this.administrativelevel)).append('\"');
        return sb.toString();
    }

    private void singleTaxCode(List<TaxLineVo> taxLineVos, List<Long> ids, BillTaxVo billTaxVo, int order) {
        DynamicObject[] taxCodes;
        long orgId = billTaxVo.getOrgId();
        long countryId = billTaxVo.getCountry();
        Date date = billTaxVo.getDate();
        String vat = billTaxVo.getTaxcodeProperty();
        for (DynamicObject taxCode : taxCodes = ObjectQueryUtils.queryTaxCode(ids, orgId, countryId, date)) {
            TaxLineVo taxLineVo = new TaxLineVo();
            String taxcodeproperty = taxCode.getString("taxcodeproperty");
            taxLineVo.setTaxType(Long.valueOf(taxCode.getLong("taxtype.id")));
            taxLineVo.setTaxCode(Long.valueOf(taxCode.getLong("id")));
            taxLineVo.setTaxRate(null);
            taxLineVo.setOffsetLogo(taxCode.getString("offsetlogo"));
            taxLineVo.setOrder(Integer.valueOf(order));
            taxLineVo.setDefaultTaxCode(StringUtils.equalsIgnoreCase((CharSequence)vat, (CharSequence)taxcodeproperty) ? Integer.valueOf(1) : Integer.valueOf(0));
            DynamicObject taxrate = ObjectQueryUtils.queryBastaxTaxcode(taxCode.getLong("id"), countryId, date);
            if (null != taxrate) {
                taxLineVo.setTaxRate(Long.valueOf(taxrate.getLong("entryentity.taxrate.id")));
                taxLineVo.setTaxRatePercent(taxrate.getBigDecimal("entryentity.taxrate.taxrate"));
            }
            taxLineVos.add(taxLineVo);
        }
    }
}

