/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.common.enums.tax.rules;

import java.util.ArrayList;
import java.util.List;
import kd.taxc.ttc.common.enums.MultiLangEnumBridge;
import kd.taxc.ttc.common.util.string.StringUtil;

public enum TaxRulesEnum {
    COUNTRY("country", "bd_country", new MultiLangEnumBridge("\u56fd\u5bb6\u5730\u533a", "TaxRulesEnum_0", "taxc-ttc"), "billlistap", "treeview_country", "tabpage_country"),
    ADMINDIVISION("admindivision", "bd_admindivision", new MultiLangEnumBridge("\u884c\u653f\u533a\u5212", "TaxRulesEnum_1", "taxc-ttc"), "billlistap1", "treeview_admindivision", "tabpage_admindivision"),
    TAXAREA("taxarea", "bastax_taxareagroup", new MultiLangEnumBridge("\u7a0e\u6536\u8f96\u533a", "TaxRulesEnum_3", "taxc-ttc"), "billlistap2", "treeview_taxarea", "tabpage_taxarea");

    private String key;
    private String name;
    private String relatedb;
    private String billistap;
    private String treeview;
    private String tabpage;
    private MultiLangEnumBridge bridge = null;

    private TaxRulesEnum(String key, String relatedb, MultiLangEnumBridge bridge, String billistap, String treeview, String tabpage) {
        this.key = key;
        this.billistap = billistap;
        this.bridge = bridge;
        this.relatedb = relatedb;
        this.treeview = treeview;
        this.tabpage = tabpage;
    }

    public static final TaxRulesEnum getEnumByKey(String key) {
        for (TaxRulesEnum taxEnum : TaxRulesEnum.values()) {
            if (!taxEnum.getKey().equalsIgnoreCase(key)) continue;
            return taxEnum;
        }
        return null;
    }

    public static final TaxRulesEnum getEnumByTreeView(String treeview) {
        for (TaxRulesEnum taxEnum : TaxRulesEnum.values()) {
            if (!taxEnum.getTreeview().equalsIgnoreCase(treeview)) continue;
            return taxEnum;
        }
        return null;
    }

    public static final TaxRulesEnum getEnumByTabpage(String tabpage) {
        for (TaxRulesEnum taxEnum : TaxRulesEnum.values()) {
            if (!taxEnum.getTabpage().equalsIgnoreCase(tabpage)) continue;
            return taxEnum;
        }
        return null;
    }

    public static final TaxRulesEnum getEnumByBillistap(String billistap) {
        for (TaxRulesEnum taxEnum : TaxRulesEnum.values()) {
            if (!taxEnum.getBillistap().equalsIgnoreCase(billistap)) continue;
            return taxEnum;
        }
        return null;
    }

    public static final List<String> getAllBillistapExcludeCurrent(String billistap) {
        ArrayList<String> billlist = new ArrayList<String>();
        for (TaxRulesEnum taxEnum : TaxRulesEnum.values()) {
            if (taxEnum.getBillistap().equalsIgnoreCase(billistap) || !StringUtil.isNotBlank((CharSequence)taxEnum.getBillistap())) continue;
            billlist.add(taxEnum.getBillistap());
        }
        return billlist;
    }

    public String getKey() {
        return this.key;
    }

    public String getBillistap() {
        return this.billistap;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getRelatedb() {
        return this.relatedb;
    }

    public String getTreeview() {
        return this.treeview;
    }

    public String getTabpage() {
        return this.tabpage;
    }
}

