/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.common.util.transactiontax;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.ttc.common.enums.transactiontax.BillTaxStepEnum;
import kd.taxc.ttc.common.util.date.DateUtils;
import kd.taxc.ttc.common.util.param.SystemParamUtil;
import kd.taxc.ttc.common.util.transactiontax.FetchValueUtils;
import kd.taxc.ttc.common.util.transactiontax.MetaDataUtils;
import kd.taxc.ttc.common.vo.transactiontax.BillTaxVo;
import kd.taxc.ttc.common.vo.transactiontax.FiledsPropertyVo;

public class TaxLogUtils {
    private static Log logger = LogFactory.getLog(TaxLogUtils.class);

    public static boolean isCloseWriteLog(String paramKey) {
        boolean isOpen = true;
        Object uselog = SystemParamUtil.getAppParameter("ttc", paramKey);
        logger.info("tax-TaxLogUtils uselog:" + uselog);
        if (uselog instanceof Boolean && ((Boolean)uselog).booleanValue()) {
            isOpen = false;
        }
        return isOpen;
    }

    public static Object getEntityFieldValue(BillTaxVo billTaxVo, String billKey, String fieldKey) {
        Object value = FetchValueUtils.fetchValue(billTaxVo, billKey, fieldKey).getValue();
        LinkedList<FiledsPropertyVo> list = MetaDataUtils.queryProperty(billKey, fieldKey);
        if (!ObjectUtils.isEmpty(list) && list.getLast().getDynamicProperty() instanceof BasedataProp) {
            BasedataProp property = (BasedataProp)list.getLast().getDynamicProperty();
            String entityName = property.getBaseEntityId();
            if (!ObjectUtils.isEmpty((Object)value) && !StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(value), (CharSequence)"0")) {
                try {
                    DynamicObject row = BusinessDataServiceHelper.loadSingle((Object)value, (String)entityName);
                    value = null == row ? value : row.getString("number") + " " + row.getString("name");
                }
                catch (Exception exception) {}
            }
        } else if (!ObjectUtils.isEmpty(list) && list.getLast().getDynamicProperty() instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)list.getLast().getDynamicProperty();
            value = comboProp.getItemByName(String.valueOf(value));
        } else if (!ObjectUtils.isEmpty(list) && list.getLast().getDynamicProperty() instanceof DateProp && value instanceof Date) {
            value = DateUtils.format((Date)value);
        }
        return value;
    }

    public static Object getEntityFieldValue(Object value, String billKey, String fieldKey) {
        LinkedList<FiledsPropertyVo> list = MetaDataUtils.queryProperty(billKey, fieldKey);
        if (!ObjectUtils.isEmpty(list) && list.getLast().getDynamicProperty() instanceof BasedataProp) {
            BasedataProp property = (BasedataProp)list.getLast().getDynamicProperty();
            String entityName = property.getBaseEntityId();
            try {
                DynamicObject row = BusinessDataServiceHelper.loadSingle((Object)value, (String)entityName);
                value = null == row ? row : row.getString("number") + " " + row.getString("name");
            }
            catch (Exception exception) {}
        } else if (!ObjectUtils.isEmpty(list) && list.getLast().getDynamicProperty() instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)list.getLast().getDynamicProperty();
            value = comboProp.getItemByName(String.valueOf(value));
        } else if (!ObjectUtils.isEmpty(list) && list.getLast().getDynamicProperty() instanceof DateProp && value instanceof Date) {
            value = DateUtils.format((Date)value);
        }
        return value;
    }

    public static void setLogV(String step, LinkedHashMap<String, String> stepLogMap, List<String> info) {
        if (!ObjectUtils.isEmpty(info)) {
            stepLogMap.put(step, org.apache.commons.lang3.StringUtils.join(info, (String)"\n"));
        }
    }

    public static LinkedHashMap<String, String> initStepMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (BillTaxStepEnum value : BillTaxStepEnum.values()) {
            map.put(value.getStepName(), ResManager.loadKDString((String)"\u65e0", (String)"TaxLogUtils_0", (String)"taxc-ttc", (Object[])new Object[0]));
        }
        return map;
    }

    public static List<String> generateSmallStepLogInfo(LinkedHashMap<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        map.forEach((smallStep, v) -> {
            sb.append((String)smallStep);
            sb.append("\n");
            sb.append((String)v);
            sb.append("\n");
        });
        list.add(sb.toString());
        return list;
    }

    public static String getLogNumber(String type, String entryNumber) {
        String spit = "-";
        String dateStr = DateUtils.format(new Date(), "yyyyMMddHHmmssSS");
        return type + spit + entryNumber + spit + dateStr;
    }
}

