/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.formplugin.tax.rules;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bd.assistant.plugin.util.BaseDataUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ttc.common.enums.tax.rules.TaxRulesEnum;

public class TaxAreaTreePlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
TabSelectListener,
TreeNodeQueryListener,
IDataModelChangeListener,
SearchEnterListener {
    private static final String CURRENT_NODE = "current_node";
    private static final String BILL_LIST = "billlistap";
    private static final String BILL_LIST_ONE = "billlistap1";
    private static final String BILL_LIST_TOW = "billlistap2";
    private static final String TABAP = "tabap";
    private static final String TABPAGE_COUNTRY = "tabpage_country";
    private static final String TREEVIEW_COUNTRY = "treeview_country";
    private static final String TABPAGE_ADMINDIVISION = "tabpage_admindivision";
    private static final String TREEVIEW_ADMINDIVISION = "treeview_admindivision";
    private static final String TABPAGE_TAXAREA = "tabpage_taxarea";
    private static final String TREEVIEW_TAXAREA = "treeview_taxarea";
    private static final String HEAD = "head";
    private static final String ROOT_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String CONTAINS_ADMINDIVI_CHILDREN = "containsadmindivichildren";
    private static final String SELECTED_LISTTAP_COUNTRY = "f7selectedlistap";
    private static final String SELECTED_LISTTAP_ADMINDIVISION = "f7selectedlistap1";
    private static final String SELECTED_LISTTAP_TAXAREA = "f7selectedlistap2";
    private static final String CURRENT_ADMINDIVISION_NODE = "current_admindivision_node";
    private static final String SEARCHAP = "searchap";
    private static final String MULTI = "multi";
    private static final String BD_COUNTRY = "bd_country";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String BASTAX_TAXAREA = "bastax_taxareagroup";
    private static final String FLAG_SEARCH = "flag_search";
    private static final String SUBTABKEY = "subTabKey";
    private static final String MULTIPLE_CHOICE_RESULT = "multiple_choice_result";
    private static final Map<String, String> billListMap = new HashMap<String, String>(3);
    private static final Map<String, String> selectF7Map = new HashMap<String, String>(3);
    private static final Map<String, String> selectandbillMap = new HashMap<String, String>(3);

    public void initialize() {
        super.initialize();
        TreeView countryAreatree = (TreeView)this.getView().getControl(TREEVIEW_COUNTRY);
        countryAreatree.addTreeNodeClickListener((TreeNodeClickListener)this);
        countryAreatree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView taxAreatree = (TreeView)this.getView().getControl(TREEVIEW_ADMINDIVISION);
        taxAreatree.addTreeNodeClickListener((TreeNodeClickListener)this);
        taxAreatree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        TreeView admindivisiontree = (TreeView)this.getView().getControl(TREEVIEW_TAXAREA);
        admindivisiontree.addTreeNodeClickListener((TreeNodeClickListener)this);
        admindivisiontree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        BillList billListCountry = (BillList)this.getView().getControl(BILL_LIST);
        billListCountry.addClearSelectionListener(this::clearSelectionListener);
        BillList billListadmindivision = (BillList)this.getView().getControl(BILL_LIST_ONE);
        billListadmindivision.addClearSelectionListener(this::clearSelectionListener);
        BillList billListtaxarea = (BillList)this.getView().getControl(BILL_LIST_TOW);
        billListtaxarea.addClearSelectionListener(this::clearSelectionListener);
        this.getPageCache().put(SUBTABKEY, TREEVIEW_COUNTRY);
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        BillList billListCountry = (BillList)this.getView().getControl(BILL_LIST);
        billListCountry.addListRowClickListener((ListRowClickListener)this);
        billListCountry.addListRowSelectAllListeners(this::ListRowSelectAllListeners);
        billListCountry.addPagerClickListener(this::clearSelectionListener);
        BillList billListadmindivi = (BillList)this.getView().getControl(BILL_LIST_ONE);
        billListadmindivi.addListRowClickListener((ListRowClickListener)this);
        billListadmindivi.addListRowSelectAllListeners(this::ListRowSelectAllListeners);
        BillList billListtaxarea = (BillList)this.getView().getControl(BILL_LIST_TOW);
        billListtaxarea.addListRowClickListener((ListRowClickListener)this);
        billListtaxarea.addListRowSelectAllListeners(this::ListRowSelectAllListeners);
        F7SelectedList f7selectedlistap = (F7SelectedList)this.getView().getControl(SELECTED_LISTTAP_COUNTRY);
        f7selectedlistap.addF7SelectedListRemoveAllListener(this::F7SelectedListRemoveAll);
        f7selectedlistap.addF7SelectedListRemoveListener(this::F7SelectedListRemove);
        F7SelectedList f7selectedlistap1 = (F7SelectedList)this.getView().getControl(SELECTED_LISTTAP_ADMINDIVISION);
        f7selectedlistap1.addF7SelectedListRemoveAllListener(this::F7SelectedListRemoveAll);
        f7selectedlistap1.addF7SelectedListRemoveListener(this::F7SelectedListRemove);
        F7SelectedList f7selectedlistap2 = (F7SelectedList)this.getView().getControl(SELECTED_LISTTAP_TAXAREA);
        f7selectedlistap2.addF7SelectedListRemoveAllListener(this::F7SelectedListRemoveAll);
        f7selectedlistap2.addF7SelectedListRemoveListener(this::F7SelectedListRemove);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadTree(TABPAGE_COUNTRY);
        this.getModel().setValue(HEAD, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5730\u5740\u6761\u4ef6", (String)"TaxAreaTreePlugin_1", (String)"taxc-ttc", (Object[])new Object[0]));
        if (this.getView().getFormShowParameter().getCustomParam(MULTI) != null) {
            boolean multi = (Boolean)this.getView().getFormShowParameter().getCustomParam(MULTI);
            BillList billstap = (BillList)this.getView().getControl(BILL_LIST);
            BillList billstap1 = (BillList)this.getView().getControl(BILL_LIST_ONE);
            BillList billstap2 = (BillList)this.getView().getControl(BILL_LIST_TOW);
            billstap.setMulti(multi);
            billstap1.setMulti(multi);
            billstap2.setMulti(multi);
            this.getView().setVisible(Boolean.valueOf(multi), new String[]{SELECTED_LISTTAP_COUNTRY, SELECTED_LISTTAP_ADMINDIVISION, SELECTED_LISTTAP_TAXAREA});
        }
    }

    public void search(SearchEnterEvent event) {
        String s = this.getPageCache().get(FLAG_SEARCH);
        if (StringUtils.isBlank((CharSequence)s)) {
            s = BILL_LIST;
        }
        BillList billstap = (BillList)this.getView().getControl(s);
        String text = event.getText();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        List fieldNames = event.getFieldNames();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            StringBuilder sb = new StringBuilder("%").append(text).append("%");
            QFilter qf = null;
            for (String fieldName : fieldNames) {
                if (qf == null) {
                    qf = new QFilter(fieldName, "like", (Object)sb.toString());
                    continue;
                }
                qf.or(fieldName, "like", (Object)sb.toString());
            }
            if (qf != null) {
                filter.and(qf);
            }
        }
        billstap.getFilterParameter().getQFilters().add(filter);
        billstap.refresh();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (CONTAINS_ADMINDIVI_CHILDREN.equalsIgnoreCase(name)) {
            boolean iscontainLower = (Boolean)e.getChangeSet()[0].getNewValue();
            TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW_ADMINDIVISION);
            String nodeId = this.getPageCache().get(CURRENT_ADMINDIVISION_NODE);
            if (nodeId == null) {
                nodeId = ROOT_ID;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_ONE);
            QFilter filter = this.getCurrentNodeAlladmindivisionChildren(nodeId, treeView, iscontainLower);
            billList.setFilter(filter);
            billList.refresh();
        }
    }

    public QFilter getCurrentNodeAlladmindivisionChildren(String nodeId, TreeView treeView, boolean iscontainLower) {
        QFilter filter = null;
        if (treeView != null) {
            if (iscontainLower) {
                if (!ROOT_ID.equalsIgnoreCase(nodeId)) {
                    if (this.isCountry(nodeId)) {
                        filter = new QFilter("country", "=", (Object)Long.valueOf(nodeId)).and("enable", "=", (Object)"1");
                    } else {
                        DynamicObject qy = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nodeId))});
                        if (qy != null) {
                            StringBuilder longnumber = new StringBuilder(qy.getString("longnumber")).append("%");
                            filter = new QFilter("longnumber", "like", (Object)longnumber).and("enable", "=", (Object)"1");
                        }
                    }
                }
            } else {
                filter = !ROOT_ID.equalsIgnoreCase(nodeId) ? new QFilter("id", "=", (Object)Long.parseLong(nodeId)).and("enable", "=", (Object)"1") : new QFilter("id", "=", (Object)0L);
            }
        }
        return filter;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String view = ((TreeView)evt.getSource()).getKey();
        String nodeId = (String)evt.getNodeId();
        this.getPageCache().put(CURRENT_NODE, nodeId);
        String bill = BILL_LIST;
        if (TREEVIEW_ADMINDIVISION.equalsIgnoreCase(view)) {
            bill = BILL_LIST_ONE;
            this.getPageCache().put(CURRENT_ADMINDIVISION_NODE, nodeId);
        } else if (TREEVIEW_TAXAREA.equalsIgnoreCase(view)) {
            bill = BILL_LIST_TOW;
        }
        this.refreshByClickTreeNode(bill);
    }

    private void refreshByClickTreeNode(String billnumber) {
        boolean iscontainLower;
        TreeView treeView;
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        BillList billList = (BillList)this.getView().getControl(billnumber);
        QFilter filter = null;
        if (!ROOT_ID.equalsIgnoreCase(nodeId) && BILL_LIST.equalsIgnoreCase(billnumber)) {
            filter = new QFilter("id", "=", (Object)Long.parseLong(nodeId)).and(new QFilter("entryentity.isamount", "=", (Object)"1")).and("enable", "=", (Object)"1");
        }
        if (!ROOT_ID.equalsIgnoreCase(nodeId) && BILL_LIST_ONE.equalsIgnoreCase(billnumber) && (filter = this.getCurrentNodeAlladmindivisionChildren(nodeId, treeView = (TreeView)this.getView().getControl(TREEVIEW_ADMINDIVISION), iscontainLower = ((Boolean)this.getModel().getValue(CONTAINS_ADMINDIVI_CHILDREN)).booleanValue())) != null) {
            filter.and("level", "<", (Object)4);
        }
        if (!ROOT_ID.equalsIgnoreCase(nodeId) && BILL_LIST_TOW.equalsIgnoreCase(billnumber)) {
            filter = new QFilter("id", "=", (Object)Long.parseLong(nodeId)).and("enable", "=", (Object)"1");
        }
        billList.setFilter(filter);
        billList.refresh();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        final Object aaa = map.get("fieldid");
        billList.addAfterBindDataListener(new AfterBindDataListener(){

            public void afterBindData(AfterBindDataEvent arg0) {
                BillList b = (BillList)arg0.getSource();
                ListSelectedRowCollection c = b.getCurrentListAllRowCollection();
                for (int i = 0; i < c.size(); ++i) {
                    if (!c.get(i).getEntryPrimaryKeyValue().toString().equals(aaa)) continue;
                    b.selectRows(i);
                }
            }
        });
    }

    public void tabSelected(TabSelectEvent evt) {
        String subTabKey = evt.getTabKey();
        this.loadTree(subTabKey);
        TaxRulesEnum enumByTabpage = TaxRulesEnum.getEnumByTabpage(subTabKey);
        if (enumByTabpage != null) {
            this.getPageCache().put(FLAG_SEARCH, enumByTabpage.getBillistap());
        }
    }

    private void loadTree(String tabpage) {
        TaxRulesEnum enumByTreeView = TaxRulesEnum.getEnumByTabpage(tabpage);
        if (enumByTreeView != null) {
            TreeView treeView = (TreeView)this.getView().getControl(enumByTreeView.getTreeview());
            String rootNodename = enumByTreeView.getName();
            this.refresh(treeView, rootNodename);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent nodeEvent) {
        String nodeId = (String)nodeEvent.getNodeId();
        String viewkey = ((TreeView)nodeEvent.getSource()).getKey();
        TreeView treeView = (TreeView)this.getView().getControl(viewkey);
        if (TREEVIEW_COUNTRY.equalsIgnoreCase(viewkey)) {
            this.queryTreeNodeCountryChildren(treeView, nodeId, (String)nodeEvent.getParentNodeId());
        } else if (TREEVIEW_ADMINDIVISION.equalsIgnoreCase(viewkey)) {
            this.queryTreeNodeChildren(treeView, nodeId);
        } else if (TREEVIEW_TAXAREA.equalsIgnoreCase(viewkey)) {
            this.queryTreeNodeTaxAreaChildren(treeView, nodeId);
        }
    }

    public TreeNode refresh(TreeView treeview, String rootNodename) {
        TreeNode rootNode = this.createRootNode(rootNodename);
        String focusNodeId = treeview.getTreeState().getFocusNodeId();
        List selectedNodeId = treeview.getTreeState().getSelectedNodeId();
        if (!StringUtils.isNotBlank((CharSequence)focusNodeId) && selectedNodeId.isEmpty()) {
            treeview.addNode(rootNode);
            treeview.focusNode(rootNode);
        }
        return rootNode;
    }

    private TreeNode createRootNode(String rootNodename) {
        TreeNode rootNode = new TreeNode();
        rootNode.setId(ROOT_ID);
        rootNode.setText(rootNodename);
        rootNode.setParentid("");
        rootNode.setIsOpened(true);
        rootNode.setChildren(new ArrayList(0));
        return rootNode;
    }

    public void queryTreeNodeTaxAreaChildren(TreeView treeview, String nodeId) {
        ArrayList nodes = new ArrayList();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(12);
        if (ROOT_ID.equals(nodeId)) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXAREA, (String)"id,number,name", null);
            if (collection != null && !collection.isEmpty()) {
                for (DynamicObject entry : collection) {
                    String id = entry.getString("id");
                    String name = entry.getString("name");
                    TreeNode node = new TreeNode();
                    node.setId(id);
                    node.setText(name);
                    node.setParentid(ROOT_ID);
                    nodeList.add(node);
                }
            }
            ArrayList nodeIds = new ArrayList();
            nodeList.forEach(item -> nodeIds.add(item.getId()));
            treeview.deleteNodes(nodeIds);
            treeview.addNodes(nodeList);
        }
        ArrayList nodeIds = new ArrayList();
        nodes.forEach(item -> nodeIds.add(item.getId()));
        treeview.deleteNodes(nodeIds);
        treeview.addNodes(nodes);
    }

    public void queryTreeNodeChildren(TreeView treeview, String nodeId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (ROOT_ID.equals(nodeId)) {
            this.forceOnRootNode(treeview, nodes);
        } else {
            this.forceOnCountryNode(nodeId, nodes);
        }
        ArrayList nodeIds = new ArrayList();
        nodes.forEach(item -> nodeIds.add(item.getId()));
        treeview.deleteNodes(nodeIds);
        treeview.addNodes(nodes);
    }

    public void queryTreeNodeCountryChildren(TreeView treeview, String nodeId, String parentId) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(12);
        if (ROOT_ID.equals(nodeId)) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)BD_COUNTRY, (String)"id,number,name", null);
            if (collection != null && !collection.isEmpty()) {
                for (DynamicObject entry : collection) {
                    String id = entry.getString("id");
                    String name = entry.getString("name");
                    TreeNode node = new TreeNode();
                    node.setId(id);
                    node.setText(name);
                    node.setParentid(ROOT_ID);
                    nodeList.add(node);
                }
            }
            ArrayList nodeIds = new ArrayList(12);
            nodeList.forEach(item -> nodeIds.add(item.getId()));
            treeview.deleteNodes(nodeIds);
            treeview.addNodes(nodeList);
        }
    }

    private void forceOnRootNode(TreeView treeview, List<TreeNode> nodes) {
        List countryTreeData = BaseDataUtils.getCountryTreeDataWithEnabled();
        ArrayList<String> countryIdList = new ArrayList<String>(16);
        for (Map map : countryTreeData) {
            TreeNode treeNode = this.changeMapToTreeNode(map);
            if (treeNode == null) continue;
            nodes.add(treeNode);
            countryIdList.add(treeNode.getId());
        }
        String countryIdListJson = JSON.toJSONString(countryIdList);
        this.getPageCache().put("countryTreeData", countryIdListJson);
    }

    private void forceOnCountryNode(String nodeId, List<TreeNode> nodes) {
        Map map2 = null;
        if (this.isCountry(nodeId)) {
            List adminDivisionTreeData = BaseDataUtils.getAdminDivisionTreeDataByCountryidWithEnabled((String)nodeId);
            for (Map map2 : adminDivisionTreeData) {
                nodes.add(this.changeMapToTreeNode(map2));
            }
        } else {
            List adminDivisionTreeData = BaseDataUtils.getAdminDivisionTreeDataWithEnabled((String)nodeId);
            for (Map map2 : adminDivisionTreeData) {
                nodes.add(this.changeMapToTreeNode(map2));
            }
        }
    }

    private boolean isCountry(String nodeId) {
        String countryIdListJson = this.getPageCache().get("countryTreeData");
        List countryIdList = (List)JSON.parseObject((String)countryIdListJson, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        return countryIdList.contains(nodeId);
    }

    private TreeNode changeMapToTreeNode(Map<String, String> map) {
        if (map.isEmpty()) {
            return null;
        }
        TreeNode node = new TreeNode();
        node.setId(map.get("id"));
        node.setText(map.get("name"));
        String parentId = map.get("parentid");
        if ("0".equals(parentId)) {
            parentId = ROOT_ID;
        }
        node.setParentid(parentId);
        String isleaf = map.get("isleaf");
        if ("false".equals(isleaf)) {
            node.setChildren(new ArrayList());
        }
        return node;
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)evt.getSource();
        String entityId = billList.getEntityId();
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        boolean ismult = true;
        if (this.getView().getFormShowParameter().getCustomParam(MULTI) != null) {
            ismult = (Boolean)this.getView().getFormShowParameter().getCustomParam(MULTI);
        }
        if (ismult) {
            String selectF7 = selectF7Map.get(entityId);
            F7SelectedList f7selectedlistap = (F7SelectedList)this.getView().getControl(selectF7);
            ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                ValueTextItem valueTextItem = new ValueTextItem(String.valueOf(listSelectedRow.getPrimaryKeyValue()), listSelectedRow.getName());
                valueTextItems.add(valueTextItem);
            }
            f7selectedlistap.addItems(valueTextItems);
        } else {
            BillList bill;
            ListSelectedRowCollection selectedRows;
            String billlist = this.getPageCache().get(FLAG_SEARCH);
            if (StringUtils.isBlank((CharSequence)billlist)) {
                billlist = BILL_LIST;
            }
            if ((selectedRows = (bill = (BillList)this.getView().getControl(billlist)).getSelectedRows()).size() > 0) {
                HashMap<String, String> map = new HashMap<String, String>();
                TaxRulesEnum enumByBillistap = TaxRulesEnum.getEnumByBillistap(billlist);
                if (enumByBillistap != null) {
                    map.put(enumByBillistap.getKey(), selectedRows.get(0).getPrimaryKeyValue().toString());
                    this.getPageCache().put(MULTIPLE_CHOICE_RESULT, JSONObject.toJSON(map).toString());
                    List<String> allBillistapExcludeCurrent = TaxRulesEnum.getAllBillistapExcludeCurrent(billlist);
                    for (String abillist : allBillistapExcludeCurrent) {
                        this.cancelSelectRow(abillist, null);
                    }
                }
            } else {
                this.getPageCache().put(MULTIPLE_CHOICE_RESULT, null);
            }
        }
    }

    private void F7SelectedListRemoveAll(EventObject e) {
        String key = ((F7SelectedList)e.getSource()).getKey();
        String bill = selectandbillMap.get(key);
        this.cancelSelectRow(bill, null);
    }

    private void F7SelectedListRemove(EventObject e) {
        F7SelectedListRemoveEvent evt = (F7SelectedListRemoveEvent)e;
        String param = evt.getParam().toString();
        String f7key = ((F7SelectedList)evt.getSource()).getKey();
        String bill = selectandbillMap.get(f7key);
        this.cancelSelectRow(bill, param);
    }

    private void cancelSelectRow(String billo, String param) {
        BillList billListCountry = (BillList)this.getView().getControl(billo);
        if (param != null) {
            ListSelectedRowCollection selectedRows = billListCountry.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                if (!selectedRow.getPrimaryKeyValue().toString().equalsIgnoreCase(param)) continue;
                int rowKey = selectedRow.getRowKey();
                IntStream stream = Arrays.stream(selectedRows.getRowKeys());
                int[] rowKeys = stream.filter(i -> i != rowKey).toArray();
                billListCountry.selectRows(rowKeys, rowKey);
            }
        } else {
            billListCountry.selectRows(new int[0], 0);
        }
    }

    private void ListRowSelectAllListeners(EventObject e) {
        String entityId = ((BillList)e.getSource()).getEntityId();
        String billlist = billListMap.get(entityId);
        BillList billList = (BillList)this.getView().getControl(billlist);
        ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
        String selectedList = selectF7Map.get(entityId);
        F7SelectedList f7selectedlistap = (F7SelectedList)this.getView().getControl(selectedList);
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            ValueTextItem valueTextItem = new ValueTextItem(String.valueOf(listSelectedRow.getPrimaryKeyValue()), listSelectedRow.getName());
            valueTextItems.add(valueTextItem);
        }
        f7selectedlistap.addItems(valueTextItems);
    }

    private void clearSelectionListener(EventObject e) {
        String entityId = ((BillList)e.getSource()).getEntityId();
        F7SelectedList f7selectedlistap = null;
        String selected = selectF7Map.get(entityId);
        f7selectedlistap = (F7SelectedList)this.getView().getControl(selected);
        if (f7selectedlistap != null) {
            f7selectedlistap.removeAllItems();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && "returndata".equalsIgnoreCase(((Donothing)args.getSource()).getOperateKey())) {
            if (this.getPageCache().get(MULTIPLE_CHOICE_RESULT) != null) {
                this.getView().getParentView().getPageCache().put(MULTIPLE_CHOICE_RESULT, this.getPageCache().get(MULTIPLE_CHOICE_RESULT));
                this.getView().returnDataToParent((Object)"multiplechoiceCallBack");
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"TaxAreaTreePlugin_0", (String)"taxc-ttc", (Object[])new Object[0]));
            }
        }
    }

    static {
        billListMap.put(BD_COUNTRY, BILL_LIST);
        billListMap.put(BD_ADMINDIVISION, BILL_LIST_ONE);
        billListMap.put(BASTAX_TAXAREA, BILL_LIST_TOW);
        selectF7Map.put(BD_COUNTRY, SELECTED_LISTTAP_COUNTRY);
        selectF7Map.put(BD_ADMINDIVISION, SELECTED_LISTTAP_ADMINDIVISION);
        selectF7Map.put(BASTAX_TAXAREA, SELECTED_LISTTAP_TAXAREA);
        selectandbillMap.put(SELECTED_LISTTAP_COUNTRY, BILL_LIST);
        selectandbillMap.put(SELECTED_LISTTAP_ADMINDIVISION, BILL_LIST_ONE);
        selectandbillMap.put(SELECTED_LISTTAP_TAXAREA, BILL_LIST_TOW);
    }
}

