/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.formplugin.tax.rules;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.ttc.common.enums.tax.rules.TaxRulesEnum;
import kd.taxc.ttc.common.util.EmptyCheckUtils;

public class TaxRulesEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String ENTYR_ENTITY = "entryentity";
    private static final String TYPE = "type";
    private static final String ITEM_RESULT = "itemresult";
    private static final String ITEM_CLASS = "itemclass";
    private static final String TYPE_CHANGE = "type_change";
    private static final String OLD_TYPEVALUE = "old_typevalue";
    private static final String ENTRY_CLASS = "entryclass";
    private static final String ENTRY_TYPE = "entrytype";
    private static final String VALUE_NAME = "valuename";
    private static final String BASTAX_ADDRESSTYPE = "bastax_addresstype";
    private static final String BASTAX_PARTY_TYPE = "bastax_party_type";
    private static final String BASTAX_TAXPRODUCT = "bastax_taxproduct";
    private static final String BASTAX_PROCESS_TYPE = "bastax_process_type";
    private static final String TTC_QUALITY_TYPE = "ttc_quality_type";
    private static final String BD_TAXAPTITUDES = "bd_taxaptitudes";
    private static final String ID = "id";
    private static final String COUNTRY_ID = "countryid";
    private static final String ENABLE = "enable";
    private static final String CREATE_ORG = "createorg";
    private static final String BD_TAXATIONSYS = "bd_taxationsys";
    private static final String TAXSYSTEM_CHANGE = "taxsystem_change";
    private static final String TAXTYPE_CHANGE = "taxtype_change";
    private static final String IGNORE_SHOWCONFIRMTIPS = "ignore_showConfirmTips";
    private static final String IGNORE_TYPE = "ignore_type";
    private static final String MULTIPLE_CHOICE_RESULT = "multiple_choice_result";
    private static final String BD_COUNTRY = "bd_country";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String BASTAX_TAXAREA = "bastax_taxareagroup";
    private static final String BD_TAX_CATEGORY = "bd_taxcategory";
    private static final String TAXAREAGROUP = "taxareagroup";
    private static final String ENTYR_ENTITY1 = "entryentity1";
    private static final String TAX_SYSTEM = "taxsystem";
    private static final String TAXTYPE = "taxtype";
    private static final String COUNTRY = "country";
    private static final String TAX_CODE_NUMBER = "taxcodenumber";
    private static final String TTC_VALUE_DIALOG = "ttc_value_dialog";
    private static final String TAXATIONSYS = "taxationsys";

    public void initialize() {
        BasedataEdit taxtype = (BasedataEdit)this.getView().getControl(TAXTYPE);
        taxtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxsystem = (BasedataEdit)this.getView().getControl(TAX_SYSTEM);
        taxsystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit type = (BasedataEdit)this.getView().getControl(TYPE);
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxcodenumber = (BasedataEdit)this.getView().getControl(TAX_CODE_NUMBER);
        taxcodenumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxcodenumber.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (TAXTYPE.equalsIgnoreCase(name)) {
            DynamicObject taxsystem = (DynamicObject)this.getModel().getValue(TAX_SYSTEM);
            if (ObjectUtils.isEmpty((Object)taxsystem)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f\u7684\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxRulesEditPlugin_0", (String)"taxc-ttc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<Long> validTaxCategory = this.getValidTaxCategory(taxsystem.getLong(ID));
            QFilter taxationsysidFilter = new QFilter(ID, "in", validTaxCategory);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(taxationsysidFilter);
        } else if (TYPE.equalsIgnoreCase(name)) {
            DynamicObject taxsystem = (DynamicObject)this.getModel().getValue(TAX_SYSTEM);
            if (ObjectUtils.isEmpty((Object)taxsystem)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f\u7684\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxRulesEditPlugin_0", (String)"taxc-ttc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter taxationsysidFilter = new QFilter(TAX_SYSTEM, "in", (Object)taxsystem.getLong(ID));
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(taxationsysidFilter);
        } else if (TAX_CODE_NUMBER.equalsIgnoreCase(name)) {
            DynamicObject taxtype = (DynamicObject)this.getModel().getValue(TAXTYPE);
            DynamicObject taxsystem = (DynamicObject)this.getModel().getValue(TAX_SYSTEM);
            if (ObjectUtils.isEmpty((Object)taxtype) || ObjectUtils.isEmpty((Object)taxsystem)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f\u7684\u7a0e\u6536\u5236\u5ea6\u548c\u7a0e\u79cd\u3002", (String)"TaxRulesEditPlugin_1", (String)"taxc-ttc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<Long> validTaxdodes = this.getValidTaxCode(taxtype, taxsystem);
            QFilter qFilter = new QFilter(ID, "in", validTaxdodes);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ListSelectedRowCollection listSelectedRows = evt.getListSelectedRowCollection();
        ArrayList<String> duplicateTaxRate = new ArrayList<String>(8);
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            for (ListSelectedRow selectedRow : listSelectedRows) {
                String itemId = String.valueOf(selectedRow.getPrimaryKeyValue());
                DynamicObject taxRate = this.isDuplicateRuleResult(itemId);
                if (taxRate == null) continue;
                duplicateTaxRate.add(taxRate.getString("name"));
            }
        }
        this.showRuleResultNotification(duplicateTaxRate);
    }

    private void showRuleResultNotification(List<String> list) {
        if (list.size() > 0) {
            String msg = StringUtils.join((Object[])list.toArray(), (String)"\u3001");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u89c4\u5219\u7ed3\u679c\uff1a%1$s", (String)"TaxRulesEditPlugin_15", (String)"taxc-ttc", (Object[])new Object[0]), msg));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (TYPE.equals(name)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (!StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.getPageCache().get(IGNORE_TYPE)) && oldValue != null) {
                this.showConfirmTips(oldValue.getString(ID));
            }
            this.getPageCache().put(IGNORE_TYPE, "false");
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
        if (ENTRY_CLASS.equals(name)) {
            this.getModel().setValue(ENTRY_TYPE, null, rowIndex);
            this.getModel().setValue(VALUE_NAME, null, rowIndex);
            this.getModel().setValue("valueid", null, rowIndex);
            this.getModel().setValue("condition", null, rowIndex);
        } else if (ENTRY_TYPE.equals(name)) {
            this.getModel().setValue(VALUE_NAME, null, rowIndex);
            this.getModel().setValue("valueid", null, rowIndex);
            this.getModel().setValue("condition", null, rowIndex);
        } else if ("condition".equals(name)) {
            this.getModel().setValue(VALUE_NAME, null, rowIndex);
            this.getModel().setValue("valueid", null, rowIndex);
        } else if (TAX_SYSTEM.equalsIgnoreCase(name)) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.showConfirmTips(name, oldValue);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)TAXTYPE, (CharSequence)name)) {
            DynamicObject oldValue;
            if (!StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.getPageCache().get(IGNORE_SHOWCONFIRMTIPS)) && (oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue()) != null) {
                this.showConfirmTips(name, oldValue);
            }
            this.getPageCache().put(IGNORE_SHOWCONFIRMTIPS, "false");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)TAXAREAGROUP, (CharSequence)name)) {
            this.clearEntryentity();
        }
    }

    private void clearEntryentity() {
        this.getModel().deleteEntryData(ENTYR_ENTITY);
        this.getModel().deleteEntryData(ENTYR_ENTITY1);
    }

    private void showConfirmTips(String fieldKey, DynamicObject oldValue) {
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)TAXTYPE)) {
            if (!"true".equals(this.getPageCache().get(TAXTYPE_CHANGE))) {
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString(ID));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection taxrateRows = this.getModel().getEntryEntity(ENTYR_ENTITY1);
                if (!ObjectUtils.isEmpty((Object)taxrateRows) && taxrateRows.size() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u79cd\uff0c\u5c06\u6e05\u7a7a\u89c4\u5219\u7ed3\u679c\u4e2d\u7684\u6570\u636e\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"TaxRulesEditPlugin_3", (String)"taxc-ttc", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(TAXTYPE_CHANGE, "false");
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)TAX_SYSTEM)) {
            if (!"true".equals(this.getPageCache().get(TAXSYSTEM_CHANGE))) {
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString(ID));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection taxrateRows = this.getModel().getEntryEntity(ENTYR_ENTITY);
                DynamicObjectCollection taxruleows = this.getModel().getEntryEntity(ENTYR_ENTITY1);
                Object taxtype = this.getModel().getValue(TAXTYPE);
                Object type = this.getModel().getValue(TYPE);
                if (!ObjectUtils.isEmpty((Object)taxrateRows) && taxrateRows.size() > 0 || !ObjectUtils.isEmpty((Object)taxruleows) && taxruleows.size() > 0 || taxtype != null || type != null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u6536\u5236\u5ea6\uff0c\u5c06\u6e05\u7a7a\u7a0e\u5219\u5206\u7c7b\u3001\u7a0e\u79cd\u3001\u89c4\u5219\u6761\u4ef6\u3001\u89c4\u5219\u7ed3\u679c\u4e2d\u7684\u6570\u636e\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"TaxRulesEditPlugin_4", (String)"taxc-ttc", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(TAXSYSTEM_CHANGE, "false");
            }
        }
    }

    private void showConfirmTips(String oldValue) {
        if (this.hasEntryRows() && !"true".equals(this.getPageCache().get(TYPE_CHANGE))) {
            this.getPageCache().put(OLD_TYPEVALUE, oldValue);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(TYPE_CHANGE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxRulesEditPlugin_5", (String)"taxc-ttc", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxRulesEditPlugin_6", (String)"taxc-ttc", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u7a0e\u5219\u5206\u7c7b\uff0c\u5c06\u4f1a\u6e05\u7a7a\u3010\u89c4\u5219\u6761\u4ef6\u3011\uff0c\u786e\u8ba4\u4fee\u6539\u5417?", (String)"TaxRulesEditPlugin_7", (String)"taxc-ttc", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.getPageCache().put(TYPE_CHANGE, "false");
        }
    }

    private boolean hasEntryRows() {
        int size = this.getModel().getEntryRowCount(ENTYR_ENTITY);
        return size > 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (TYPE_CHANGE.equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getPageCache().put(TYPE_CHANGE, "false");
                this.getModel().deleteEntryData(ENTYR_ENTITY);
                this.getModel().createNewEntryRow(ENTYR_ENTITY);
            } else {
                Long oldId = Long.valueOf(this.getPageCache().get(OLD_TYPEVALUE));
                this.getPageCache().put(TYPE_CHANGE, "true");
                this.getModel().setValue(TYPE, (Object)oldId);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)TAXTYPE)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(TAXTYPE_CHANGE, "false");
                this.getModel().deleteEntryData(ENTYR_ENTITY1);
            } else {
                this.getPageCache().put(TAXTYPE_CHANGE, "true");
                this.getModel().setValue(fieldKey, (Object)this.getPageCache().get(fieldKey));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)TAX_SYSTEM)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(TAXSYSTEM_CHANGE, "false");
                this.getPageCache().put(IGNORE_SHOWCONFIRMTIPS, "true");
                this.getPageCache().put(IGNORE_TYPE, "true");
                this.getModel().setValue(TAXTYPE, null);
                this.getModel().setValue(TYPE, null);
                this.getModel().deleteEntryData(ENTYR_ENTITY);
                this.getModel().deleteEntryData(ENTYR_ENTITY1);
            } else {
                this.getPageCache().put(TAXSYSTEM_CHANGE, "true");
                this.getModel().setValue(fieldKey, (Object)this.getPageCache().get(fieldKey));
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{VALUE_NAME});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (VALUE_NAME.equalsIgnoreCase(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
            String itemClass = (String)this.getModel().getValue(ENTRY_CLASS, rowIndex);
            DynamicObject itemType = (DynamicObject)this.getModel().getValue(ENTRY_TYPE, rowIndex);
            String condition = (String)this.getModel().getValue("condition", rowIndex);
            if (itemClass != null && condition != null) {
                DynamicObject createorg = (DynamicObject)this.getModel().getValue(CREATE_ORG);
                DynamicObject country = null;
                if (createorg != null) {
                    country = (DynamicObject)createorg.get(COUNTRY);
                }
                String type = String.valueOf(itemType == null ? "" : itemType.get("number"));
                if (itemType == null && !BASTAX_TAXPRODUCT.equals(itemClass)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u3010\u7a0e\u8981\u7d20\u5c0f\u7c7b\u3011", (String)"TaxRulesEditPlugin_8", (String)"taxc-ttc", (Object[])new Object[0]));
                    return;
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                Date now = new Date();
                String formId = "";
                String zdysysType = "";
                boolean isMultiSelect = false;
                switch (itemClass) {
                    case "bastax_addresstype": {
                        formId = "bastax_addressterms";
                        qFilters.add(new QFilter("addtype.number", "=", (Object)type));
                        break;
                    }
                    case "bastax_party_type": {
                        formId = "bastax_party";
                        qFilters.add(new QFilter("group.number", "=", (Object)type));
                        break;
                    }
                    case "bastax_process_type": {
                        Long id;
                        QFilter idQFilter;
                        DynamicObject dynamicObject;
                        if (itemType == null || !EmptyCheckUtils.isNotEmpty(dynamicObject = BusinessDataServiceHelper.loadSingle((String)BASTAX_PROCESS_TYPE, (String)"id,name,number,processtype,datasourcevar", (QFilter[])new QFilter[]{idQFilter = new QFilter(ID, "=", (Object)(id = Long.valueOf(itemType.getLong(ID))))}))) break;
                        String processtype = dynamicObject.getString("processtype");
                        if ("0".equals(processtype)) {
                            DynamicObject dy = dynamicObject.getDynamicObject("datasourcevar");
                            if (dy != null) {
                                formId = dy.getString(ID);
                            }
                            zdysysType = "0";
                            break;
                        }
                        if ("1".equals(processtype)) {
                            formId = "bastax_process";
                            zdysysType = "1";
                            qFilters.add(new QFilter("group.number", "=", (Object)type));
                            break;
                        }
                        if ("2".equals(processtype)) {
                            formId = TTC_VALUE_DIALOG;
                            zdysysType = "2";
                            break;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7a0e\u8981\u7d20\u5c0f\u7c7b\u6ca1\u6709\u7ef4\u62a4\u5bf9\u5e94\u7684\u503c\u7c7b\u578b\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"TaxRulesEditPlugin_9", (String)"taxc-ttc", (Object[])new Object[0]));
                        return;
                    }
                    case "bastax_taxproduct": {
                        formId = BASTAX_TAXPRODUCT;
                        break;
                    }
                    case "ttc_quality_type": {
                        formId = BD_TAXAPTITUDES;
                    }
                }
                if (!"=".equals(condition) && !"<>".equals(condition)) {
                    isMultiSelect = true;
                }
                qFilters.add(new QFilter(ENABLE, "=", (Object)"1"));
                if (!BASTAX_ADDRESSTYPE.equals(itemClass)) {
                    QFilter date = new QFilter("startdate", "<=", (Object)now);
                    date.and(new QFilter("enddate", ">=", (Object)now).or(QFilter.isNull((String)"enddate")));
                    qFilters.add(date);
                }
                this.showBaseDataForm(formId, isMultiSelect, qFilters, zdysysType);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u8981\u7d20\u5206\u7c7b\u53ca\u6761\u4ef6\u5b57\u6bb5", (String)"TaxRulesEditPlugin_10", (String)"taxc-ttc", (Object[])new Object[0]));
            }
        }
    }

    private void showBaseDataForm(String formId, boolean isMultiSelect, List<QFilter> qFilters, String zdysysType) {
        if ("bastax_addressterms".equalsIgnoreCase(formId)) {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("openModel", "add");
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("530");
            inlineStyleCss.setWidth("960");
            param.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            param.setFormId("ttc_tax_rules_area");
            param.setCustomParam("multi", (Object)false);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showFormAddressCallBack"));
            this.getView().showForm(param);
        } else if (EmptyCheckUtils.isEmpty(zdysysType)) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
            listShowParameter.getListFilterParameter().setQFilters(qFilters);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showFormCallBack"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("2".equals(zdysysType)) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
            String valuename = this.getView().getModel().getValue(VALUE_NAME, row).toString();
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(formId);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TTC_VALUE_DIALOG));
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put(VALUE_NAME, valuename);
            parameter.setCustomParams(params);
            this.getView().showForm(parameter);
        } else {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
            if ("1".equals(zdysysType)) {
                listShowParameter.setFormId("bos_listf7");
                listShowParameter.getListFilterParameter().setQFilters(qFilters);
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showFormCallBack"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() != null) {
            String callBackID = event.getActionId();
            if ("showFormCallBack".equalsIgnoreCase(callBackID)) {
                ArrayList<String> ids = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<String> numbers = new ArrayList<String>();
                ListSelectedRowCollection rt = (ListSelectedRowCollection)event.getReturnData();
                for (ListSelectedRow row : rt) {
                    ids.add(row.getPrimaryKeyValue().toString());
                    numbers.add(row.getNumber());
                    names.add(row.getName());
                }
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
                this.getModel().setValue("valueid", (Object)StringUtils.join((Object[])ids.toArray(), (String)","), rowIndex);
                this.getModel().setValue(VALUE_NAME, (Object)StringUtils.join((Object[])names.toArray(), (String)","), rowIndex);
                this.getModel().setValue("valuenumber", (Object)StringUtils.join((Object[])numbers.toArray(), (String)","), rowIndex);
            } else if ("showFormAddressCallBack".equalsIgnoreCase(callBackID)) {
                if (event.getReturnData().toString().equalsIgnoreCase("multiplechoiceCallBack")) {
                    HashMap address = (HashMap)JSONObject.parseObject((String)this.getPageCache().get(MULTIPLE_CHOICE_RESULT), HashMap.class);
                    Set keyset = address.keySet();
                    Iterator iterator = keyset.iterator();
                    String level = null;
                    String id = null;
                    while (iterator.hasNext()) {
                        level = iterator.next().toString();
                        id = address.get(level).toString();
                    }
                    String querykey = null;
                    querykey = TaxRulesEnum.getEnumByKey(level).getRelatedb();
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)querykey, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(id))});
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTYR_ENTITY);
                    this.getModel().setValue("valueid", (Object)id, rowIndex);
                    this.getModel().setValue(VALUE_NAME, (Object)dynamicObject.getString("name"), rowIndex);
                    this.getModel().setValue("valuenumber", (Object)dynamicObject.getString("number"), rowIndex);
                    this.getModel().setValue("administrativelevel", (Object)level, rowIndex);
                }
            } else if (TTC_VALUE_DIALOG.equalsIgnoreCase(callBackID)) {
                Map result = (Map)event.getReturnData();
                if (result == null) {
                    return;
                }
                String value = (String)result.get(VALUE_NAME);
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTYR_ENTITY);
                int[] indexs = entryGrid.getSelectRows();
                this.getModel().setValue("valuenumber", (Object)value, indexs[0]);
                this.getModel().setValue("valueid", (Object)value, indexs[0]);
                this.getModel().setValue(VALUE_NAME, (Object)value, indexs[0]);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            int size = this.getModel().getEntryRowCount(ENTYR_ENTITY);
            for (int i = 0; i < size; ++i) {
                DynamicObject entrytype;
                String entryclass = (String)this.getModel().getValue(ENTRY_CLASS, i);
                if (entryclass == null) {
                    args.setCancel(true);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u884c%s\uff1a\u7a0e\u8981\u7d20\u5927\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxRulesEditPlugin_11", (String)"taxc-ttc", (Object[])new Object[0]), i + 1));
                }
                if ((entrytype = (DynamicObject)this.getModel().getValue(ENTRY_TYPE, i)) != null || BASTAX_TAXPRODUCT.equals(entryclass)) continue;
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u884c%s\uff1a\u8bf7\u5148\u9009\u62e9\u7a0e\u8981\u7d20\u5c0f\u7c7b", (String)"TaxRulesEditPlugin_12", (String)"taxc-ttc", (Object[])new Object[0]), i + 1));
            }
            DynamicObjectCollection taxruleows = this.getModel().getEntryEntity(ENTYR_ENTITY1);
            if (taxruleows == null || taxruleows.size() == 0) {
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u81f3\u5c11\u4e00\u6761\u89c4\u5219\u7ed3\u679c\u3002", (String)"TaxRulesEditPlugin_13", (String)"taxc-ttc", (Object[])new Object[0]), new Object[0]));
                return;
            }
            boolean error = false;
            for (DynamicObject taxrule : taxruleows) {
                if (taxrule.get(TAX_CODE_NUMBER) != null) continue;
                error = true;
                break;
            }
            if (error) {
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7a0e\u7801\u7f16\u7801\u201d\u3002", (String)"TaxRulesEditPlugin_14", (String)"taxc-ttc", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    public List<Long> getValidTaxType(long countryid) {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        QFilter filter = new QFilter(ENABLE, "=", (Object)"1").and(COUNTRY_ID, "=", (Object)countryid).and("activedate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)BD_TAXATIONSYS, (String)"id,number,expdate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("expdate") != null && bd.getDate("expdate").getTime() < new Date().getTime()) continue;
            bids.add(bd.getLong(ID));
        }
        return bids;
    }

    public List<Long> getValidTaxCategory(long taxationsysid) {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        QFilter filter = new QFilter(ENABLE, "=", (Object)"1").and("taxationsysid", "=", (Object)taxationsysid).and("activedate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)BD_TAX_CATEGORY, (String)"id,number,expdate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("expdate") != null && DateUtils.addDays((Date)bd.getDate("expdate"), (int)1).getTime() < new Date().getTime()) continue;
            bids.add(bd.getLong(ID));
        }
        return bids;
    }

    public List<Long> getValidTaxCode(DynamicObject taxtype, DynamicObject taxationsys) {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        Long taxtypeid = taxtype.getLong(ID);
        Long taxationsysid = taxationsys.getLong(ID);
        QFilter filter = new QFilter(ENABLE, "=", (Object)"1").and(new QFilter(TAXATIONSYS, "=", (Object)taxationsysid)).and(new QFilter(TAXTYPE, "=", (Object)taxtypeid)).and("startdate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)"bastax_taxcode", (String)"id,number,enddate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("enddate") != null && bd.getDate("enddate").getTime() < new Date().getTime()) continue;
            bids.add(bd.getLong(ID));
        }
        return bids;
    }

    private DynamicObject isDuplicateRuleResult(String id) {
        int size = this.getModel().getEntryRowCount(ENTYR_ENTITY1);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            DynamicObject taxrate = (DynamicObject)this.getModel().getValue(TAX_CODE_NUMBER, i);
            if (ObjectUtils.isEmpty((Object)taxrate) || !id.equalsIgnoreCase(taxrate.getString(ID)) || ++count <= 1) continue;
            this.getModel().deleteEntryRow(ENTYR_ENTITY1, i);
            return taxrate;
        }
        return null;
    }
}

