/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.formplugin.tax.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.ttc.common.enums.tax.rules.TaxRulesEnum;

public class TaxRulesListPlugin
extends AbstractListPlugin {
    private static final Map<String, String> classMap = new HashMap<String, String>();

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] objArray = e.getQueryValues();
        if (objArray != null && objArray.length > 0) {
            for (DynamicObject itemObj : objArray) {
                DynamicObjectCollection entryCol = (DynamicObjectCollection)itemObj.get("entryentity");
                if (entryCol == null || entryCol.size() <= 0) continue;
                for (DynamicObject entry : entryCol) {
                    String entryclass = entry.getString("entryclass");
                    Long id = entry.getLong("id");
                    String level = entry.getString("administrativelevel");
                    String number = this.queryEntryNumber(entryclass, id, level);
                    entry.set("valuenumber", (Object)number);
                }
            }
        }
    }

    private String queryEntryNumber(String classType, Long id, String level) {
        DynamicObjectCollection d;
        QFilter idFilter;
        QFilter filter = new QFilter("entryentity.id", "=", (Object)id);
        DynamicObject entry = QueryServiceHelper.queryOne((String)"ttc_tax_rules", (String)"id,entryentity.valueid", (QFilter[])new QFilter[]{filter});
        String valueid = entry.getString("entryentity.valueid");
        if (valueid != null && valueid.contains(",")) {
            String[] ids = valueid.split(",");
            long[] idarr = Arrays.asList(ids).stream().mapToLong(Long::parseLong).toArray();
            idFilter = new QFilter("id", "in", (Object)idarr);
        } else {
            idFilter = new QFilter("id", "=", (Object)Long.parseLong(valueid));
        }
        String entityName = classMap.get(classType);
        if ("bastax_addresstype".equalsIgnoreCase(classType) && level != null) {
            entityName = TaxRulesEnum.getEnumByKey(level).getRelatedb();
        }
        if ((d = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{idFilter})) != null && d.size() > 0) {
            ArrayList<String> numbers = new ArrayList<String>(d.size());
            for (DynamicObject item : d) {
                numbers.add(item.getString("number"));
            }
            return StringUtils.join((Object[])numbers.toArray(), (String)",");
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Donothing && "maintenancetype".equalsIgnoreCase(((Donothing)args.getSource()).getOperateKey())) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("ttc_tax_rules_type");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    static {
        classMap.put("bastax_addresstype", "bastax_addressterms");
        classMap.put("bastax_party_type", "bastax_party");
        classMap.put("bastax_process_type", "bastax_process");
        classMap.put("bastax_taxproduct", "bastax_taxproduct");
        classMap.put("country", "bd_country");
        classMap.put("taxarea", "bastax_taxareagroup");
    }
}

