/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.formplugin.tax.rules;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.BatchFillEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.ttc.TtcValueRulesSceneidEnum;
import kd.taxc.ttc.business.rules.ValueRulesBusiness;
import kd.taxc.ttc.common.enums.valuerules.ValueRulesEnum;
import kd.taxc.ttc.common.util.string.StringUtil;

public class ValueRulesEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String VALUERULES_ENTRY = "valuerules_entry";
    private static final String BD_MATERIALGROUP = "bd_materialgroup";
    private static final String MATERIALTAXONOMY = "materialtaxonomy";
    private static final String SOURCETYPE = "sourcetype";
    private static final String TAXATIONSYSID = "taxationsysid";
    private static final String SCENEID = "sceneid";
    private static final String TARGETTYPE = "targettype";
    private static final String TARGETOBJECTID = "targetobjectid";
    private static final String TAXELEMENT = "taxelement";
    private static final String BASICDATANUMBER = "basicdatanumber";
    private static final String TARGETNUMBER = "targetnumber";
    private static final String materialtaxonomy_change = "materialtaxonomy_change";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BASICDATANUMBER});
        this.addClickListeners(new String[]{TARGETNUMBER});
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl(SCENEID);
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        mulBasedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit basicDataType = (BasedataEdit)this.getControl("basicdatatype");
        basicDataType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetobjectid = (BasedataEdit)this.getControl(TARGETOBJECTID);
        targetobjectid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        DynamicObject focusRow;
        EntryGrid entryGrid;
        StyleCss css;
        MainEntityType entityType;
        FormConfig formConfig;
        ListShowParameter showParameter;
        String entity;
        DynamicObject dynamicObject;
        if (this.checkApplication()) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BASICDATANUMBER)) {
            dynamicObject = (DynamicObject)this.getView().getModel().getValue(ValueRulesEnum.BASICDATATYPE.getKey());
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5bf9\u8c61\uff01", (String)"ValueRulesEdit_0", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            entity = dynamicObject.getString("number");
            showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38\uff01", (String)"ValueRulesEdit_1", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            entityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (ObjectUtils.isEmpty((Object)entityType.getAlias())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ValueRulesEdit_2", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            showParameter.setFormId(formConfig.getF7ListFormId());
            css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(false);
            showParameter.setMultiSelect(false);
            showParameter.setLookUp(true);
            showParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            showParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            showParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY);
            focusRow = this.getModel().getEntryRowEntity(VALUERULES_ENTRY, entryGrid.getEntryState().getFocusRow());
            showParameter.setSelectedRow((Object)focusRow.getLong("sourcevalue"));
            if (this.getApplication("ttc")) {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                List sourcevalueIdList = dynamicObjectCollection.stream().map(d -> d.getLong("sourcevalue")).collect(Collectors.toList());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", sourcevalueIdList));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BASICDATANUMBER);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)TARGETNUMBER)) {
            dynamicObject = (DynamicObject)this.getView().getModel().getValue(ValueRulesEnum.TARGETOBJECTID.getKey());
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5bf9\u8c61\uff01", (String)"ValueRulesEdit_3", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            entity = dynamicObject.getString("number");
            showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38\uff01", (String)"ValueRulesEdit_1", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            entityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (ObjectUtils.isEmpty((Object)entityType.getAlias())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ValueRulesEdit_2", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            showParameter.setFormId(formConfig.getF7ListFormId());
            css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(false);
            showParameter.setMultiSelect(false);
            showParameter.setLookUp(true);
            showParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            showParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            showParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY);
            focusRow = this.getModel().getEntryRowEntity(VALUERULES_ENTRY, entryGrid.getEntryState().getFocusRow());
            showParameter.setSelectedRow((Object)focusRow.getLong("targetvalue"));
            List<TtcValueRulesSceneidEnum> list = ValueRulesBusiness.getTtcValueRulesSceneidEnum(this.getModel());
            List qFilterList = list.stream().filter(sceneEnum -> null != sceneEnum.dealTargetValueFilter(this.getView())).map(o -> o.dealTargetValueFilter(this.getView())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(qFilterList)) {
                QFilter idQ = QFilter.isNull((String)"id");
                for (QFilter filter : qFilterList) {
                    idQ.or(filter);
                }
                showParameter.getListFilterParameter().getQFilters().add(idQ);
            }
            if (this.getApplication("ttc")) {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                List targetvalueIdList = dynamicObjectCollection.stream().map(d -> d.getLong("targetvalue")).collect(Collectors.toList());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", targetvalueIdList));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, TARGETNUMBER);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRow row;
        Iterator iterator;
        boolean isFirst;
        DynamicObjectCollection dynamicObjectCollection;
        ArrayList<String> duplicateValue;
        ListSelectedRowCollection listDatas;
        if (this.checkApplication()) {
            return;
        }
        boolean ttc = this.getApplication("ttc");
        if (StringUtils.equalsIgnoreCase((CharSequence)BASICDATANUMBER, (CharSequence)closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            duplicateValue = new ArrayList<String>(8);
            dynamicObjectCollection = this.getModel().getEntryEntity(VALUERULES_ENTRY);
            isFirst = true;
            iterator = listDatas.iterator();
            while (iterator.hasNext() && !this.removeDupliceValue(ttc, duplicateValue, row = (ListSelectedRow)iterator.next(), "sourcevalue")) {
                isFirst = this.setEntryGrid(dynamicObjectCollection, isFirst, row, "sourcevalue", BASICDATANUMBER, "basicdata");
            }
            this.showValueNotification(duplicateValue);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)TARGETNUMBER, (CharSequence)closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) && listDatas.size() > 0) {
            duplicateValue = new ArrayList(8);
            dynamicObjectCollection = this.getModel().getEntryEntity(VALUERULES_ENTRY);
            isFirst = true;
            iterator = listDatas.iterator();
            while (iterator.hasNext() && !this.removeDupliceValue(ttc, duplicateValue, row = (ListSelectedRow)iterator.next(), "targetvalue")) {
                isFirst = this.setEntryGrid(dynamicObjectCollection, isFirst, row, "targetvalue", TARGETNUMBER, "targetname");
            }
            this.showValueNotification(duplicateValue);
        }
    }

    private boolean checkApplication() {
        DynamicObjectCollection application = (DynamicObjectCollection)this.getModel().getValue("application");
        if (application.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9002\u7528\u573a\u666f\u3002", (String)"ValueRulesEdit_4", (String)"taxc-ttc", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean removeDupliceValue(boolean ttc, List<String> duplicateValue, ListSelectedRow row, String targetvalue) {
        String itemId;
        String basicdataId;
        if (ttc && (basicdataId = this.isDuplicateValue(itemId = String.valueOf(row.getPrimaryKeyValue()), targetvalue)) != null) {
            duplicateValue.add(row.getName());
            return true;
        }
        return false;
    }

    private boolean setEntryGrid(DynamicObjectCollection dynamicObjectCollection, boolean isFirst, ListSelectedRow row, String targetvalue, String targetnumber, String targetname) {
        EntryGrid entryGridList = (EntryGrid)this.getControl(VALUERULES_ENTRY);
        int[] indexs = entryGridList.getSelectRows();
        if (isFirst) {
            this.getModel().setValue(targetvalue, row.getPrimaryKeyValue(), indexs[0]);
            this.getModel().setValue(targetnumber, (Object)row.getNumber(), indexs[0]);
            this.getModel().setValue(targetname, (Object)row.getName(), indexs[0]);
            isFirst = false;
        } else {
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            int index = this.getModel().createNewEntryRow(VALUERULES_ENTRY, dynamicObject);
            this.getModel().setValue(targetvalue, row.getPrimaryKeyValue(), index);
            this.getModel().setValue(targetnumber, (Object)row.getNumber(), index);
            this.getModel().setValue(targetname, (Object)row.getName(), index);
        }
        return isFirst;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)TAXELEMENT, (CharSequence)key)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("country");
            if (dynamicObject == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f\u7684\u56fd\u5bb6\u6216\u5730\u533a\u3002", (String)"ValueRulesEdit_5", (String)"taxc-ttc", (Object[])new Object[0]));
                return;
            }
            QFilter qfilter = new QFilter("country", "=", (Object)dynamicObject.getLong("id"));
            QFilter dateQFilter = new QFilter("enddate", "is null", null).and(new QFilter("startdate", "<=", (Object)new Date()));
            QFilter dateQFilter1 = new QFilter("enddate", "is not null", null).and(new QFilter("startdate", "<=", (Object)new Date())).and(new QFilter("enddate", ">=", (Object)new Date()));
            qfilter.and(dateQFilter.or(dateQFilter1));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(qfilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SCENEID, (CharSequence)key)) {
            String appId = this.getView().getFormShowParameter().getAppId();
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("applicationid.number", "=", (Object)appId));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"basicdatatype", (CharSequence)key)) {
            List<TtcValueRulesSceneidEnum> list = ValueRulesBusiness.getTtcValueRulesSceneidEnum(this.getModel());
            ArrayList basicDataTypeList = new ArrayList();
            list.stream().filter(row -> !ObjectUtils.isEmpty((Object)row.getBasicDataTypeFilterList())).forEach(row -> basicDataTypeList.addAll(row.getBasicDataTypeFilterList()));
            if (!ObjectUtils.isEmpty(basicDataTypeList)) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", basicDataTypeList));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)TARGETOBJECTID, (CharSequence)key)) {
            List<TtcValueRulesSceneidEnum> list = ValueRulesBusiness.getTtcValueRulesSceneidEnum(this.getModel());
            ArrayList targetObjectIdTypeList = new ArrayList();
            list.stream().filter(row -> !ObjectUtils.isEmpty((Object)row.getTargetObjectIdTypeFilterList())).forEach(row -> targetObjectIdTypeList.addAll(row.getTargetObjectIdTypeFilterList()));
            if (!ObjectUtils.isEmpty(targetObjectIdTypeList)) {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", targetObjectIdTypeList));
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Object source = afterF7SelectEvent.getSource();
        if (source instanceof MulBasedataEdit && StringUtil.equalsIgnoreCase((CharSequence)SCENEID, (CharSequence)((MulBasedataEdit)source).getKey())) {
            List<TtcValueRulesSceneidEnum> list = ValueRulesBusiness.getTtcValueRulesSceneidEnum(this.getModel());
            list.stream().forEach(row -> row.dealEnable(this.getView()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        DynamicObject newObject;
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)ValueRulesEnum.BASICDATATYPE.getKey(), (CharSequence)fieldKey) && null == (newObject = (DynamicObject)e.getChangeSet()[0].getNewValue())) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)TAXATIONSYSID, (CharSequence)fieldKey)) {
            newObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (null == newObject) {
                return;
            }
            this.getModel().setValue("country", (Object)newObject.getDynamicObject("countryid").getLong("id"));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)MATERIALTAXONOMY, (CharSequence)fieldKey)) {
            DynamicObjectCollection oldValue2 = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
            if (!"true".equals(this.getPageCache().get(materialtaxonomy_change))) {
                List materialtaxonomyIds = oldValue2.stream().map(o -> o.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList());
                this.getPageCache().put(fieldKey, SerializationUtils.toJsonString(materialtaxonomyIds));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection rows = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                if (!ObjectUtils.isEmpty((Object)rows) && rows.size() > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7269\u6599\u5206\u7c7b\u6807\u51c6\uff0c\u5c06\u6e05\u7a7a\u5217\u8868\u884c\u6570\u636e\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"ValueRulesEdit_6", (String)"taxc-ttc", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(materialtaxonomy_change, "false");
            }
            return;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)SCENEID, (CharSequence)fieldKey)) {
            newObject = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            List idList = newObject.stream().map(n -> n.getDynamicObject("fbasedataid").getDynamicObject("applicationid").getString("id")).collect(Collectors.toList());
            this.getModel().setValue("application", (Object)idList.toArray());
            return;
        }
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            Object obj = e.getChangeSet()[0].getOldValue();
            if (obj instanceof DynamicObject) {
                oldValue = (DynamicObject)obj;
                this.showConfirmTips(fieldKey, (DynamicObject)oldValue);
            } else if (obj instanceof String) {
                oldValue = (String)obj;
                this.showConfirmTips(fieldKey, (String)oldValue);
            }
        }
        String mainKey = null;
        if (TARGETTYPE.equals(fieldKey)) {
            mainKey = TARGETOBJECTID;
        } else if (SOURCETYPE.equals(fieldKey)) {
            mainKey = "basicdatatype";
        }
        if (StringUtils.isNotEmpty((CharSequence)mainKey)) {
            oldValue = (DynamicObject)this.getModel().getValue(mainKey);
            String value = ObjectUtils.isEmpty((Object)oldValue) ? null : oldValue.getString("id");
            this.getPageCache().put(mainKey, value);
            this.getModel().getDataEntity().set(mainKey, null);
            this.getView().updateView(mainKey);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject newObject = (DynamicObject)this.getModel().getValue(TAXATIONSYSID);
        this.getModel().setValue("country", (Object)newObject.getDynamicObject("countryid").getLong("id"));
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getView().getFormShowParameter().getAppId(), (CharSequence)"tcvat")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SOURCETYPE, TARGETTYPE});
            this.getModel().setValue(SOURCETYPE, (Object)"basedata");
            this.getModel().setValue(TARGETTYPE, (Object)"basedata");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<TtcValueRulesSceneidEnum> list = ValueRulesBusiness.getTtcValueRulesSceneidEnum(this.getModel());
        list.stream().forEach(row -> row.dealEnable(this.getView()));
        this.dealSourceTargetEnable();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            ValueRulesEnum valueRulesEnum = ValueRulesEnum.getEnumByKey(fieldKey);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(valueRulesEnum.getChange(), "false");
                this.getModel().deleteEntryData(VALUERULES_ENTRY);
            } else {
                this.getPageCache().put(valueRulesEnum.getChange(), "true");
                String mainKey = null;
                String oldValue = null;
                if (TARGETTYPE.equals(fieldKey)) {
                    mainKey = TARGETOBJECTID;
                    oldValue = this.getPageCache().get(TARGETOBJECTID);
                } else if (SOURCETYPE.equals(fieldKey)) {
                    mainKey = "basicdatatype";
                    oldValue = this.getPageCache().get("basicdatatype");
                }
                this.getModel().setValue(valueRulesEnum.getKey(), (Object)this.getPageCache().get(valueRulesEnum.getKey()));
                if (StringUtils.isNotEmpty((CharSequence)mainKey)) {
                    this.getModel().setValue(mainKey, (Object)oldValue);
                }
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)MATERIALTAXONOMY, (CharSequence)fieldKey)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(materialtaxonomy_change, "false");
                this.getModel().deleteEntryData(VALUERULES_ENTRY);
            } else {
                this.getPageCache().put(materialtaxonomy_change, "true");
                List ids = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(fieldKey), Object.class);
                this.getModel().setValue(MATERIALTAXONOMY, (Object)ids.toArray());
            }
        }
    }

    private void showConfirmTips(String fieldKey, DynamicObject oldValue) {
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            ValueRulesEnum valueRulesEnum = ValueRulesEnum.getEnumByKey(fieldKey);
            if (!"true".equals(this.getPageCache().get(valueRulesEnum.getChange()))) {
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString("id"));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection rows = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                if (!ObjectUtils.isEmpty((Object)rows) && rows.size() > 0) {
                    this.getView().showConfirm(valueRulesEnum.getShowConfirm(), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(valueRulesEnum.getChange(), "false");
            }
        }
    }

    private void showConfirmTips(String fieldKey, String oldValue) {
        if (ValueRulesEnum.getKeys().contains(fieldKey)) {
            ValueRulesEnum valueRulesEnum = ValueRulesEnum.getEnumByKey(fieldKey);
            if (!"true".equals(this.getPageCache().get(valueRulesEnum.getChange()))) {
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                DynamicObjectCollection rows = this.getModel().getEntryEntity(VALUERULES_ENTRY);
                if (!ObjectUtils.isEmpty((Object)rows) && rows.size() > 0) {
                    this.getView().showConfirm(valueRulesEnum.getShowConfirm(), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            } else {
                this.getPageCache().put(valueRulesEnum.getChange(), "false");
            }
        }
    }

    private void showValueNotification(List<String> list) {
        if (list.size() > 0 && this.getApplication("ttc")) {
            String msg = StringUtils.join((Object[])list.toArray(), (String)"\u3001");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u57fa\u7840\u8d44\u6599\u503c\uff1a%s", (String)"ValueRulesEdit_7", (String)"taxc-ttc", (Object[])new Object[0]), msg));
        }
    }

    private boolean getApplication(String appid) {
        DynamicObjectCollection application = (DynamicObjectCollection)this.getModel().getValue("application");
        return application.stream().map(a -> a.getDynamicObject("fbasedataid").getString("number")).filter(a -> a.equals(appid)).count() > 0L;
    }

    private String isDuplicateValue(String id, String cellName) {
        int size = this.getModel().getEntryRowCount(VALUERULES_ENTRY);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            String sourcevalue = String.valueOf(this.getModel().getValue(cellName, i));
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY);
            if (ObjectUtils.isEmpty((Object)6) || !StringUtils.equalsIgnoreCase((CharSequence)sourcevalue, (CharSequence)id) || entryGrid.getEntryState().getFocusRow() == i || ++count <= 0) continue;
            return sourcevalue;
        }
        return null;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (!ObjectUtils.isEmpty((Object)e.getSourceData()) && e.getSourceData() instanceof JSONObject) {
            String basicDataTypeNumber;
            QFilter basicNumber;
            JSONObject jsonObject = (JSONObject)e.getSourceData();
            String countryNumber = jsonObject.getJSONObject("country").getString("number");
            String taxelementType = jsonObject.getString("taxelementtype");
            String basicDataType = jsonObject.getJSONObject(ValueRulesEnum.BASICDATATYPE.getKey()).getString("name");
            QFilter basicName = new QFilter("name", "=", (Object)basicDataType);
            DynamicObjectCollection entityObjects = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,number", (QFilter[])new QFilter[]{basicName, basicNumber = new QFilter("number", "=", (Object)(basicDataTypeNumber = jsonObject.getJSONObject(ValueRulesEnum.BASICDATATYPE.getKey()).getString("number")))});
            if (!ObjectUtils.isEmpty((Object)entityObjects) && entityObjects.size() > 0) {
                JSONArray basicValues = jsonObject.getJSONArray(VALUERULES_ENTRY);
                String entity = ((DynamicObject)entityObjects.get(0)).getString("number");
                for (Object object : basicValues) {
                    DynamicObjectCollection basicDataTpyes;
                    JSONObject row = (JSONObject)object;
                    String basicdata = row.getString("basicdata");
                    String basicdataNumber = row.getString(BASICDATANUMBER);
                    QFilter nameFilter = new QFilter("name", "=", (Object)basicdata);
                    QFilter numberFilter = new QFilter("number", "=", (Object)basicdataNumber);
                    String taxelementNumber = row.getJSONObject(TAXELEMENT).getString("number");
                    String taxelementName = row.getJSONObject(TAXELEMENT).getString("name");
                    if (!QueryServiceHelper.exists((String)taxelementType, (QFilter[])new QFilter[]{new QFilter("country.number", "=", (Object)countryNumber).and(new QFilter("number", "=", (Object)taxelementNumber))})) {
                        e.setCancel(true);
                        e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5728\u6240\u5c5e\u7684\u56fd\u5bb6\u6216\u5730\u533a\u67e5\u4e0d\u5230\u7a0e\u52a1\u8981\u7d20\u503c:%s", (String)"ValueRulesEdit_8", (String)"taxc-ttc", (Object[])new Object[0]), taxelementName));
                    }
                    if (!ObjectUtils.isEmpty((Object)(basicDataTpyes = QueryServiceHelper.query((String)entity, (String)"id,number", (QFilter[])new QFilter[]{nameFilter, numberFilter}))) && basicDataTpyes.size() > 0) {
                        DynamicObject dynamicObject = (DynamicObject)basicDataTpyes.get(0);
                        row.put("sourcevalue", (Object)dynamicObject.getString("id"));
                        row.put(BASICDATANUMBER, (Object)dynamicObject.getString("number"));
                        continue;
                    }
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u57fa\u7840\u8d44\u6599\u503c\uff1a%s", (String)"ValueRulesEdit_9", (String)"taxc-ttc", (Object[])new Object[0]), basicdata));
                }
            } else {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff1a%s", (String)"ValueRulesEdit_10", (String)"taxc-ttc", (Object[])new Object[0]), basicDataType));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject focusRow;
        String taxelement;
        EntryGrid entryGrid;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof BatchFillEntry && StringUtils.equalsIgnoreCase((CharSequence)TAXELEMENT, (CharSequence)(entryGrid = (EntryGrid)this.getView().getControl(VALUERULES_ENTRY)).getEntryState().getFocusField()) && ObjectUtils.isEmpty((Object)(taxelement = (focusRow = this.getModel().getEntryRowEntity(VALUERULES_ENTRY, entryGrid.getEntryState().getFocusRow())).getString(TAXELEMENT)))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u503c\u7684\u5355\u5143\u683c\u7528\u4e8e\u586b\u5145\uff01", (String)"ValueRulesEdit_11", (String)"taxc-ttc", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newentry")) {
            this.dealSourceTargetEnable();
        }
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit control = (FieldEdit)this.getControl(key);
        control.setMustInput(mustInput);
    }

    private void dealSourceTargetEnable() {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(VALUERULES_ENTRY);
        if (null != collection) {
            IntStream.range(0, collection.size()).forEach(focus -> {
                this.getView().setEnable(Boolean.valueOf(!StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString(SOURCETYPE), (CharSequence)"basedata")), focus, new String[]{"basicdata"});
                this.setMustInput(BASICDATANUMBER, StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString(SOURCETYPE), (CharSequence)"basedata"));
                IDataEntityProperty property = this.getModel().getProperty(BASICDATANUMBER);
                if (property instanceof TextProp) {
                    ((TextProp)property).setMustInput(StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString(SOURCETYPE), (CharSequence)"basedata"));
                }
                this.getView().setEnable(Boolean.valueOf(!StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString(TARGETTYPE), (CharSequence)"basedata")), focus, new String[]{"targetname"});
                this.setMustInput(TARGETNUMBER, StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString(TARGETTYPE), (CharSequence)"basedata"));
                IDataEntityProperty targetNumberProp = this.getModel().getProperty(TARGETNUMBER);
                if (targetNumberProp instanceof TextProp) {
                    ((TextProp)targetNumberProp).setMustInput(StringUtil.equalsIgnoreCase((CharSequence)this.getModel().getDataEntity().getString(TARGETTYPE), (CharSequence)"basedata"));
                }
            });
        }
    }
}

