/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.opplugin.tax.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ValueRuleSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject object = dataEntity.getDataEntity();
                    String ctrlstrategy = object.getString("ctrlstrategy");
                    if (!"5".equals(ctrlstrategy) && !"7".equals(ctrlstrategy)) {
                        return;
                    }
                    DynamicObjectCollection sceneidCollect = object.getDynamicObjectCollection("sceneid");
                    List sceneidList = sceneidCollect.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    DynamicObject taxationsysid = object.getDynamicObject("taxationsysid");
                    QFilter filter = new QFilter("ctrlstrategy", "in", Arrays.asList("5", "7")).and(new QFilter("taxationsysid", "=", (Object)taxationsysid.getLong("id"))).and(new QFilter("sceneid.fbasedataid.id", "in", sceneidList)).and(new QFilter("number", "!=", (Object)object.getString("number")));
                    DynamicObject existsObject = QueryServiceHelper.queryOne((String)"ttc_valuerules", (String)"number", (QFilter[])new QFilter[]{filter});
                    if (null != existsObject) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ba1\u63a7\u7b56\u7565\u4e3a\u5168\u5c40\u5171\u4eab\u6216\u79c1\u6709\u65f6\uff0c\u540c\u4e00\u573a\u666f\u53ca\u7a0e\u6536\u5236\u5ea6\u4e0b\u5df2\u5b58\u5728\u7f16\u7801\u4e3a:%s \u7684\u6570\u636e,\u8bf7\u5148\u5220\u9664\u5df2\u6709\u6570\u636e\u3002", (String)"ValueRuleSaveOp_2", (String)"taxc-ttc", (Object[])new Object[0]), existsObject.getString("number")));
                        return;
                    }
                    DynamicObjectCollection valuerulesEntry = object.getDynamicObjectCollection("valuerules_entry");
                    HashSet<String> resultSet = new HashSet<String>();
                    for (DynamicObject entry : valuerulesEntry) {
                        String key = entry.getString("sourcevalue") + entry.getString("basicdata") + entry.getString("basicdatanumber") + entry.getString("targetvalue") + entry.getString("targetname") + entry.getString("targetnumber");
                        if (resultSet.contains(key)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u6e90\u503c\u6216\u76ee\u6807\u503c\u3002", (String)"ValueRuleSaveOp_1", (String)"taxc-ttc", (Object[])new Object[0]));
                            continue block0;
                        }
                        resultSet.add(key);
                    }
                }
            }
        });
    }
}

