/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ttc.mservice.taxrule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.ttc.business.taxcode.TaxRuleBusiness;
import kd.taxc.ttc.business.taxcode.impl.TaxRuleBusinessImpl;
import kd.taxc.ttc.common.vo.transactiontax.BillTaxVo;
import kd.taxc.ttc.common.vo.transactiontax.FourPVo;
import kd.taxc.ttc.mservice.api.taxrule.BillTaxCalculateService;
import org.apache.commons.lang3.ObjectUtils;

public class BillTaxCalculateServiceImpl
implements BillTaxCalculateService {
    private static Log logger = LogFactory.getLog(BillTaxCalculateServiceImpl.class);
    private TaxRuleBusiness taxRuleService = new TaxRuleBusinessImpl();

    @Override
    public Map<String, Object> service(long orgid, long country, long taxationsys, String ttctag, Date validDate, List<Long> taxTypeList, List<Map<Long, Long>> taxProductList, List<Map<Long, Long>> addressTypeList, List<Map<Long, Long>> taxAptitudeList, List<Map<Long, Long>> processList) {
        logger.info("tax-BillTaxCalculateServiceImpl: \u5f00\u59cb\u8c03\u7528\u63a5\u53e3");
        ArrayList fourPVoList = new ArrayList(16);
        if (taxProductList != null) {
            taxProductList.stream().forEach(m -> m.keySet().stream().forEach(key -> fourPVoList.add(new FourPVo("bastax_taxproduct", ((Long)m.get(key)).longValue(), key.longValue(), ""))));
        }
        if (addressTypeList != null) {
            addressTypeList.stream().forEach(m -> m.keySet().stream().forEach(key -> fourPVoList.add(new FourPVo("bastax_addresstype", ((Long)m.get(key)).longValue(), key.longValue(), ttctag))));
        }
        if (taxAptitudeList != null) {
            taxAptitudeList.stream().forEach(m -> m.keySet().stream().forEach(key -> fourPVoList.add(new FourPVo("ttc_quality_type", ((Long)m.get(key)).longValue(), key.longValue(), ""))));
        }
        if (processList != null) {
            processList.stream().forEach(m -> m.keySet().stream().forEach(key -> fourPVoList.add(new FourPVo("bastax_process_type", ((Long)m.get(key)).longValue(), key.longValue(), ""))));
        }
        BillTaxVo billTaxVo = new BillTaxVo(orgid, country, validDate, "", 0L, "", "", "", null, null, "", "", null, Long.valueOf(taxationsys), taxTypeList.get(0));
        List list = new ArrayList(16);
        try {
            list = this.taxRuleService.service(billTaxVo, fourPVoList, "new");
        }
        catch (KDBizException e) {
            logger.error("tax-BillTaxCalculateServiceImpl", (Throwable)e);
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), list);
        }
        return ServiceResultUtils.returnResultHandler(list);
    }

    @Override
    public Map<String, Object> batchServiceByOrgAndTaxationsys(long orgid, long country, long taxationsys, String ttctag, Date validDate, List<Long> taxTypeList, List<Map<String, Map<Long, Long>>> taxFourPList) {
        logger.info("tax-BillTaxCalculateServiceImpl-batchServiceByOrgAndTaxationsys: \u5f00\u59cb\u8c03\u7528\u63a5\u53e3");
        ArrayList allFourPVoList = new ArrayList(16);
        if (ObjectUtils.isNotEmpty(taxFourPList)) {
            for (Map<String, Map<Long, Long>> fourP : taxFourPList) {
                ArrayList fourPVoList = new ArrayList(16);
                if (fourP.containsKey("taxProduct")) {
                    Map<Long, Long> taxProduct = fourP.get("taxProduct");
                    taxProduct.entrySet().stream().forEach(m -> fourPVoList.add(new FourPVo("bastax_taxproduct", ((Long)m.getValue()).longValue(), ((Long)m.getKey()).longValue(), "")));
                }
                if (fourP.containsKey("addressType")) {
                    Map<Long, Long> addressType = fourP.get("addressType");
                    addressType.entrySet().stream().forEach(m -> fourPVoList.add(new FourPVo("bastax_addresstype", ((Long)m.getValue()).longValue(), ((Long)m.getKey()).longValue(), ttctag)));
                }
                if (fourP.containsKey("taxAptitude")) {
                    Map<Long, Long> taxAptitude = fourP.get("taxAptitude");
                    taxAptitude.entrySet().stream().forEach(m -> fourPVoList.add(new FourPVo("ttc_quality_type", ((Long)m.getValue()).longValue(), ((Long)m.getKey()).longValue(), "")));
                }
                if (fourP.containsKey("process")) {
                    Map<Long, Long> process = fourP.get("process");
                    process.entrySet().stream().forEach(m -> fourPVoList.add(new FourPVo("bastax_process_type", ((Long)m.getValue()).longValue(), ((Long)m.getKey()).longValue(), "")));
                }
                allFourPVoList.add(fourPVoList);
            }
        }
        DynamicObject[] dynamicObjects = this.batchServiceByOrgAndTaxationsys(orgid, country, taxationsys, ttctag, validDate, taxTypeList);
        HashMap taxcoderesultMap = new HashMap(16);
        try {
            taxcoderesultMap.putAll(this.taxRuleService.batchService(dynamicObjects, allFourPVoList));
        }
        catch (KDBizException e) {
            logger.error("tax-BillTaxCalculateServiceImpl-batchServiceByOrgAndTaxationsys", (Throwable)e);
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), taxcoderesultMap);
        }
        return ServiceResultUtils.returnResultHandler(taxcoderesultMap);
    }

    public DynamicObject[] batchServiceByOrgAndTaxationsys(long orgid, long country, long taxationsys, String ttctag, Date validDate, List<Long> taxTypeList) {
        BillTaxVo billTaxVo = new BillTaxVo(orgid, country, validDate, "", 0L, "", "", "", null, null, "", "", null, Long.valueOf(taxationsys), taxTypeList);
        return this.taxRuleService.batchServiceByOrgAndTaxationsys(billTaxVo);
    }
}

