/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.mservice;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.mservice.api.ICadresWithdrawDepartHandleService;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.bussiness.servicehelper.TDCConsumerServiceHelper;
import kd.tdc.tdcs.common.constants.coordination.CoordTaskStatusEnum;

public class CadresWithdrawDepartHandleService
implements ICadresWithdrawDepartHandleService {
    private static final Log LOG = LogFactory.getLog(CadresWithdrawDepartHandleService.class);
    private static final ExternalService externalService = (ExternalService)kd.tdc.tdcs.bussiness.ServiceFactory.getService(ExternalService.class);
    private static final NominateApplicationService NOMINATE_APPLICATION_SERVICE = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final ExpedBillApplicationService EXPED_APPLICATION_SERVICE = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeMsg(DynamicObject coordinationMsg, Map<String, Object> coordinationMap) {
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)coordinationMsg.getString("msgcontent"));
        long recordId = Long.parseLong(String.valueOf(msgContent.get("recordId")));
        DLock lock = DLock.create((String)MessageFormat.format("CadresWithdrawDepartHandleService_{0}", recordId));
        try {
            if (lock.tryLock(60000L)) {
                Map returnData = externalService.getPerIdByChgCategoryId(Long.valueOf(recordId));
                if (CollectionUtils.isEmpty((Map)returnData) || !((Boolean)returnData.get("success")).booleanValue()) {
                    LOG.error("Changed-transaction-records-cannot-be-queried-by-recordId,errorMsg:{}", returnData.get("errorMsg"));
                    this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff1a{0}\u3002", (String)"CadresDepartHandleService_0", (String)"tdc-cadm-mservice", (Object[])new Object[]{returnData.get("errorMsg")}));
                }
                Map data = (Map)returnData.get("data");
                LOG.info("consumeMsg data:{}", (Object)data);
                List perIdList = (List)data.get("data");
                List<Long> personIds = perIdList.stream().filter(p -> p.get("hrpi_person") != null).map(p -> ((Map)p.get("hrpi_person")).get("boid")).filter(p -> p != null).map(p -> (Long)p).distinct().collect(Collectors.toList());
                LOG.info("consumeMsg personIds:{}", personIds);
                personIds.forEach(personBoId -> {
                    LOG.info("WithdrawCadresDepart personId:{}", personBoId);
                    NOMINATE_APPLICATION_SERVICE.handleWithdrawDepartCadresAppointBill(personBoId);
                    EXPED_APPLICATION_SERVICE.handleWithdrawDepartCadresExpedBill(personBoId);
                });
                this.buildResultMap(coordinationMap, CoordTaskStatusEnum.SUCCESS, ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\u3002", (String)"CadresDepartHandleService_3", (String)"tdc-cadm-mservice", (Object[])new Object[0]));
            } else {
                this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb\uff0c\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CadresDepartHandleService_1", (String)"tdc-cadm-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, ResManager.loadKDString((String)"\u5904\u7406\u5728\u9014\u6d41\u7a0b\u5f02\u5e38\u3002", (String)"CadresDepartHandleService_2", (String)"tdc-cadm-mservice", (Object[])new Object[0]));
            LOG.error("CadresWithdrawDepartHandleService###CadresWithdrawDepartHandleService###exception", (Throwable)exception);
        }
        finally {
            LOG.info("CadresWithdrawDepartHandleService-coordinationMap:{}", coordinationMap);
            TDCConsumerServiceHelper.callBackResult((DynamicObject)coordinationMsg, coordinationMap);
            lock.unlock();
        }
    }
}

