/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.appoint;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ActBillStatusCheckValidator
extends HRDataBaseValidator {
    private static final Map<String, String> SELECT_FIELDS_MAP = Maps.newHashMap();

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            List<Object> billPkIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
            Map<Long, DynamicObject> bills = this.getBills(this.entityKey, billPkIds);
            for (Object dataEntity : dataEntities) {
                String statusField = SELECT_FIELDS_MAP.get(this.entityKey);
                String status = bills.get(dataEntity.getDataEntity().getLong("id")).getString(statusField);
                if (HRStringUtils.equals((String)((String)dataEntity.getValue(statusField)), (String)status)) continue;
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ActBillStatusCheckValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<Long, DynamicObject> getBills(String entityName, List<Object> billPkIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] bills = serviceHelper.query(SELECT_FIELDS_MAP.get(this.entityKey), new QFilter[]{new QFilter("id", "in", billPkIds)});
        return Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
    }

    static {
        SELECT_FIELDS_MAP.put("cadm_publicity", "pubstatus");
        SELECT_FIELDS_MAP.put("cadm_reviewbill", "reviewstatus");
        SELECT_FIELDS_MAP.put("cadm_appointrelease", "releasestatus");
        SELECT_FIELDS_MAP.put("cadm_appointaudit", "appoauditstatus");
        SELECT_FIELDS_MAP.put("cadm_examinebill", "examinestatus");
        SELECT_FIELDS_MAP.put("cadm_appointissue", "issuestatus");
    }
}

