/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.appoint;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import org.apache.commons.lang3.StringUtils;

public class BillStatusCheckValidator
extends HRDataBaseValidator {
    private String[] statusFields;

    public BillStatusCheckValidator(String ... statusFields) {
        this.statusFields = statusFields;
    }

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities) && !HRArrayUtils.isEmpty((Object[])this.statusFields)) {
            Map<Long, DynamicObject> bills = this.getBills((ExtendedDataEntity[])dataEntities);
            if (CollectionUtils.isEmpty(bills)) {
                return;
            }
            block0: for (Object dataEntity : dataEntities) {
                DynamicObject bill = bills.get(Long.valueOf(dataEntity.getBillPkId().toString()));
                for (String statusName : this.statusFields) {
                    String newStatus;
                    String oldStatus = dataEntity.getDataEntity().getString(statusName);
                    if (HRStringUtils.equals((String)oldStatus, (String)(newStatus = bill.getString(statusName)))) continue;
                    this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"BillStatusCheckValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
            }
        }
    }

    private Map<Long, DynamicObject> getBills(ExtendedDataEntity[] dataEntities) {
        List billPkIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        String entityName = dataEntities[0].getDataEntity().getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        String selectFields = "id," + StringUtils.join((Object[])this.statusFields, (String)",");
        DynamicObject[] bills = serviceHelper.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", billPkIds)});
        return Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
    }
}

