/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.appointaudit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.AuditBillApplicationService;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;

public class AppointAuditRejectValidator
extends HRDataBaseValidator {
    private static final AuditBillApplicationService auditBillApplicationService = (AuditBillApplicationService)ServiceFactory.getService(AuditBillApplicationService.class);

    public void validate() {
        super.validate();
        if (!HRArrayUtils.isEmpty((Object[])this.dataEntities)) {
            List billPkIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
            DynamicObject[] bills = auditBillApplicationService.queryAuditBillById("id,appoauditstatus", billPkIds);
            Map<Long, DynamicObject> billMap = Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                String status = billMap.get(dataEntity.getDataEntity().getLong("id")).getString("appoauditstatus");
                if (AppointAuditStatusEnum.canBeRejected((String)status)) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u9a73\u56de\u5ba1\u67e5\u72b6\u6001\u4e3a\u201c\u5f85\u5ba1\u67e5\u201d\u7684\u6570\u636e\u3002", (String)"AppointAuditRejectValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

