/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.brew;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewSaveValidator
extends HRDataBaseValidator {
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);

    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject brewObject = null;
            String positionType = bill.getString("positiontype") == null ? "" : bill.getString("positiontype");
            String typeName = "";
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                brewObject = bill.getDynamicObject("brewstandardposition");
                typeName = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"BrewSubmitValidator_5", (String)"tdc-cadm-opplugin", (Object[])new Object[0]);
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                brewObject = bill.getDynamicObject("brewposition");
                typeName = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"BrewSubmitValidator_6", (String)"tdc-cadm-opplugin", (Object[])new Object[0]);
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                brewObject = bill.getDynamicObject("brewjob");
                typeName = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"BrewSubmitValidator_7", (String)"tdc-cadm-opplugin", (Object[])new Object[0]);
            }
            if (brewObject == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u915d\u917f{0}\u201d\u3002", (String)"BrewSubmitValidator_8", (String)"tdc-cadm-opplugin", (Object[])new Object[]{typeName}));
                continue;
            }
            ArrayList enumList = Lists.newArrayList((Object[])new String[]{BrewStatusEnum.FORBREW.getNumber(), BrewStatusEnum.BREWING.getNumber()});
            Long billPkId = (Long)dataEntity.getBillPkId();
            DynamicObject existBillInfo = brewBillApplicationService.getBrewBillByList("billno,brewstatus", (List)enumList, brewObject.getLong("id"), billPkId.longValue(), positionType);
            if (HRObjectUtils.isEmpty((Object)existBillInfo)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{2}\u201d\u5df2\u5b58\u5728\u201c{1}\u201d\u915d\u917f\u52a8\u8bae\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"BrewSubmitValidator_9", (String)"tdc-cadm-opplugin", (Object[])new Object[]{BrewStatusEnum.getName((String)existBillInfo.getString("brewstatus")), existBillInfo.getString("billno"), typeName}));
        }
    }
}

