/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.brew;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.BrewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.brew.enums.BrewStatusEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class BrewSubmitValidator
extends HRDataBaseValidator {
    private static final BrewBillApplicationService brewBillApplicationService = (BrewBillApplicationService)ServiceFactory.getService(BrewBillApplicationService.class);

    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            String brewStatus = bill.getString("brewstatus");
            if (BrewStatusEnum.BREWOVER.getNumber().equals(brewStatus)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u915d\u917f\u72b6\u6001\u4e3a\u201c\u915d\u917f\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"BrewSubmitValidator_10", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
                continue;
            }
            String positionType = bill.getString("positiontype") == null ? "" : bill.getString("positiontype");
            DynamicObject brewObject = null;
            String typeName = "";
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                brewObject = bill.getDynamicObject("brewstandardposition");
                typeName = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"BrewSubmitValidator_5", (String)"tdc-cadm-opplugin", (Object[])new Object[0]);
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                brewObject = bill.getDynamicObject("brewposition");
                typeName = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"BrewSubmitValidator_6", (String)"tdc-cadm-opplugin", (Object[])new Object[0]);
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                brewObject = bill.getDynamicObject("brewjob");
                typeName = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"BrewSubmitValidator_7", (String)"tdc-cadm-opplugin", (Object[])new Object[0]);
            }
            if (brewObject == null) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u915d\u917f\u5c97\u4f4d/\u804c\u4f4d/\u6807\u51c6\u5c97\u4f4d\u4e3a\u7a7a\uff0c\u5355\u636e\u7f16\u53f7\uff1a{0}", (String)"BrewSubmitValidator_4", (String)"tdc-cadm-opplugin", (Object[])new Object[]{bill.getString("billno")}));
                continue;
            }
            ArrayList enumList = Lists.newArrayList((Object[])new String[]{BrewStatusEnum.FORBREW.getNumber(), BrewStatusEnum.BREWING.getNumber()});
            Long billPkId = (Long)dataEntity.getBillPkId();
            DynamicObject existBillInfo = brewBillApplicationService.getBrewBillByList("billno,brewstatus", (List)enumList, brewObject.getLong("id"), billPkId.longValue(), positionType);
            if (!HRObjectUtils.isEmpty((Object)existBillInfo)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c{2}\u201d\u5df2\u5b58\u5728\u201c{1}\u201d\u915d\u917f\u52a8\u8bae\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"BrewSubmitValidator_11", (String)"tdc-cadm-opplugin", (Object[])new Object[]{BrewStatusEnum.getName((String)existBillInfo.getString("brewstatus")), existBillInfo.getString("billno"), typeName}));
                continue;
            }
            if (bill.getDynamicObjectCollection("entryentity").size() == 0) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0{0}\u915d\u917f\u5019\u9009\u4eba\u3002", (String)"BrewSubmitValidator_12", (String)"tdc-cadm-opplugin", (Object[])new Object[]{typeName}));
                continue;
            }
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            int emptyCandidateCount = 0;
            for (DynamicObject entry : entryEntity) {
                String brewConclusion = entry.getString("brewconclusion");
                if (HRObjectUtils.isEmpty((Object)entry.get("brewcomment")) || HRObjectUtils.isEmpty((Object)brewConclusion)) {
                    ++emptyCandidateCount;
                    continue;
                }
                if (!HRStringUtils.equals((String)brewConclusion, (String)"1") || !HRObjectUtils.isEmpty((Object)entry.get("nomhandler"))) continue;
                ++emptyCandidateCount;
            }
            if (emptyCandidateCount == 0) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6709{0}\u4e2a\u5019\u9009\u4eba\u915d\u917f\u7ed3\u679c\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5f55\u5165\u915d\u917f\u7ed3\u679c\u4fe1\u606f\u3002", (String)"BrewSubmitValidator_3", (String)"tdc-cadm-opplugin", (Object[])new Object[]{emptyCandidateCount}));
        }
    }
}

