/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.database;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class AuditSchemeSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObjectCollection entryRows = dataEntity.getDataEntity().getDynamicObjectCollection("audititementry");
            Map<String, Long> auditItemCountMap = entryRows.stream().map(row -> row.getDynamicObject("audititem")).collect(Collectors.groupingBy(auditItem -> auditItem.getString("number"), Collectors.counting()));
            boolean existRepeat = auditItemCountMap.values().stream().anyMatch(num -> num > 1L);
            if (!existRepeat) continue;
            String repeatNumber = auditItemCountMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (String)entry.getKey()).collect(Collectors.joining(","));
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u67e5\u65b9\u6848\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5ba1\u67e5\u9879\u7f16\u7801{0}\u3002", (String)"AuditSchemeSaveValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[]{repeatNumber}));
        }
    }
}

