/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.dismiss;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.DismissBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;

public class DismissSubmitValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(DismissSubmitValidator.class);
    private static final DismissBillApplicationService dismissBillApplicationService = (DismissBillApplicationService)ServiceFactory.getService(DismissBillApplicationService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, List<DynamicObject>> toBeSubmittedBillMap = Arrays.stream(dataEntities).map(p -> p.getDataEntity()).collect(Collectors.groupingBy(p -> p.getLong("employee.id")));
        ArrayList<Long> employeeIds = new ArrayList<Long>(toBeSubmittedBillMap.keySet());
        DynamicObject[] submittedBills = dismissBillApplicationService.getDismissBillInAppointByEmployee(employeeIds);
        Map<Long, List<DynamicObject>> submittedBillMap = Arrays.stream(submittedBills).filter(bill -> bill.get("dismisstenure") != null && bill.getLong("dismisstenure.id") != 0L).collect(Collectors.groupingBy(p -> p.getLong("employee.id")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            List<DynamicObject> toBeSubmittedBillList;
            List toBeSubmittedRepeatBillList;
            String appointStatus;
            DynamicObject dismissBill = dataEntity.getDataEntity();
            DynamicObject dTenure = dismissBill.getDynamicObject("dismisstenure");
            if (null == dTenure) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u514d\u4efb\u5c97\"\u3002", (String)"DismissSubmitValidator_4", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
            if (!(appointStatus = dismissBill.getString("appointstatus")).equals(AppointStatusEnum.WAIT_APPOINT.getVal())) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u4efb\u514d\u72b6\u6001\u4e3a\u201c\u5f85\u4efb\u514d\u201d\u7684\u6570\u636e\u3002", (String)"DismissSubmitValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
                continue;
            }
            long employeeId = dismissBill.getLong("employee.id");
            long dismissTenureId = dismissBill.getLong("dismisstenure.id");
            DynamicObject person = dismissBill.getDynamicObject("person");
            String personName = person.getString("name");
            String personNumber = person.getString("number");
            List<DynamicObject> submittedBillList = submittedBillMap.get(employeeId);
            if (!CollectionUtils.isEmpty(submittedBillList)) {
                List submittedRepeatBillList = submittedBillList.stream().filter(p -> dismissTenureId == p.getLong("dismisstenure.id")).collect(Collectors.toList());
                for (DynamicObject repeatBill : submittedRepeatBillList) {
                    String billNo = repeatBill.getString("billno");
                    String applyKind = repeatBill.getString("applykind");
                    if (ApplyKindEnum.DISMISS.getNumber().equals(applyKind)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u7684\u514d\u804c\u5df2\u5b58\u5728\u4e8e\"{2}\"\u514d\u804c\u7533\u8bf7\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"DismissSubmitValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[]{personName, personNumber, billNo}));
                    }
                    if (!ApplyKindEnum.APPOINT.getNumber().equals(applyKind)) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u7684\u514d\u804c\u5df2\u5b58\u5728\u4e8e\"{2}\"\u4efb\u547d\u63d0\u540d\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"DismissSubmitValidator_3", (String)"tdc-cadm-opplugin", (Object[])new Object[]{personName, personNumber, billNo}));
                }
            }
            if ((toBeSubmittedRepeatBillList = (toBeSubmittedBillList = toBeSubmittedBillMap.get(employeeId)).stream().filter(p -> dismissTenureId == p.getLong("dismisstenure.id")).collect(Collectors.toList())).size() > 1) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u201c{0}\u201d\u201c{1}\u201d\u91cd\u590d\u514d\u804c\u3002", (String)"DismissSubmitValidator_2", (String)"tdc-cadm-opplugin", (Object[])new Object[]{personName, personNumber}));
            }
            this.checkActivityScheme(dataEntity);
        }
    }

    private void checkActivityScheme(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        try {
            Map resultMap = ACTV_SERVICE.getActivitySchemeMapFromWorkflow(entity);
            boolean success = (Boolean)resultMap.get("success");
            if (!success) {
                logger.error("dismiss submit --> getActivitySchemeMapFromWorkflow fail");
                String errorMsg = (String)resultMap.get("errorMsg");
                this.addFatalErrorMessage(dataEntity, errorMsg);
            }
        }
        catch (Exception exception) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6d3b\u52a8\u7f16\u6392\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DismissSubmitValidator_5", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            String message = MessageFormat.format("call hrcs error:{0}", entity.getString("billno"));
            logger.error(message, (Throwable)exception);
        }
    }
}

