/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.examine;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;

public class ExamCoopSaveValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(ExamCoopSaveValidator.class);
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);

    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            long currUserId;
            DynamicObject examCoop = dataEntity.getDataEntity();
            long billId = examCoop.getLong("id");
            String billNo = examCoop.getString("billno");
            DynamicObject examCoopInDb = examCoopBillApplicationService.queryExamCoopBillById("coopstatus,coophandler", Long.valueOf(billId));
            String coopStatusInDb = examCoopInDb.getString("coopstatus");
            List userIds = examCoopInDb.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (!ExamCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatusInDb)) {
                LOG.info("examCoopStatus anomaly, billNo: {}, coopStatus: {}", (Object)billNo, (Object)coopStatusInDb);
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamCoopSaveValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
            if (userIds.contains(currUserId = RequestContext.get().getCurrUserId())) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExamCoopSaveValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }
}

