/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.examine;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;

public class ExamineBillRejectValidator
extends HRDataBaseValidator {
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            List billPkIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
            DynamicObject[] bills = examineBillApplicationService.queryExamineBillById("examinestatus", billPkIds);
            Map<Long, DynamicObject> billMap = Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                String status = billMap.get(dataEntity.getDataEntity().getLong("id")).getString("examinestatus");
                if (ExamineStatusEnum.canBeRejected((String)status)) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u9a73\u56de\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u8003\u5bdf/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ExamineBillRejectValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

