/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.exped;

import java.text.MessageFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedCoopBillApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.common.constants.AppointCommonConstants;

public class ExpedCoopUrgeValidator
extends HRDataBaseValidator {
    private static final ExpedCoopBillApplicationService examCoopService = (ExpedCoopBillApplicationService)ServiceFactory.getService(ExpedCoopBillApplicationService.class);

    public void validate() {
        super.validate();
        Long id = Long.valueOf(this.getOption().getVariableValue("id"));
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            long halfHourMills;
            long pastMills;
            DynamicObject examCoop = examCoopService.queryExpedCoopBillById("coopstatus,urgetime", id);
            String coopStatus = examCoop.getString("coopstatus");
            if (!ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u50ac\u529e\u8003\u5bdf\u534f\u4f5c\u72b6\u6001\u4e3a\u201c\u5f85\u5904\u7406\u201d\u7684\u6570\u636e\u3002", (String)"ExpedCoopUrgeValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date urgeTime = examCoop.getDate("urgetime");
            if (urgeTime == null || (pastMills = System.currentTimeMillis() - urgeTime.getTime()) >= (halfHourMills = AppointCommonConstants.MILLISECONDS_HALF_HOUR.longValue())) continue;
            long waitMinutesTime = (halfHourMills - pastMills) / 1000L / 60L;
            long waitSecondsTime = (halfHourMills - pastMills) / 1000L % 60L;
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u534f\u529e\u5df2\u53d1\u9001\u50ac\u529e\u6d88\u606f\uff0c\u518d\u6b21\u53d1\u9001\u8fd8\u9700\u7b49\u5f85{0}\u5206{1}\u79d2\u3002", (String)"ExpedCoopUrgeValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]), waitMinutesTime, waitSecondsTime));
        }
    }
}

