/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.issue;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;

public class IssueBillStatusValidator
extends HRDataBaseValidator {
    private static final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private final List<String> validateIssueStatus;

    public IssueBillStatusValidator(List<String> validateStatus) {
        this.validateIssueStatus = validateStatus;
    }

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        DynamicObject[] issueBills = issueBillApplicationService.queryIssueBillById("issuestatus", billIds);
        Map<Long, String> statusMap = Arrays.stream(issueBills).collect(Collectors.toMap(issueBill -> issueBill.getLong("id"), issueBill -> issueBill.getString("issuestatus")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Long billPkId = (Long)dataEntity.getBillPkId();
            String issueStatus = statusMap.get(billPkId);
            if (this.validateIssueStatus.contains(issueStatus)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"IssueBillStatusValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }
}

