/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.nominate;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.common.enums.RecommendSourceEnum;

public class NominateSubmitValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(NominateSubmitValidator.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);

    public void validate() {
        super.validate();
        ConcurrentMap dismissMap = Maps.newConcurrentMap();
        Map<Long, List<DynamicObject>> emp2DyMap = Arrays.stream(this.getDataEntities()).map(p -> p.getDataEntity()).collect(Collectors.groupingBy(p -> HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("employee"))));
        this.validateDismiss(dismissMap);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Long billPkId = (Long)dataEntity.getBillPkId();
            boolean paramCheck = this.checkParam(dataEntity);
            if (!paramCheck) continue;
            this.positionValidate(dataEntity, billPkId, dismissMap, emp2DyMap);
        }
    }

    private boolean checkParam(ExtendedDataEntity dataEntity) {
        boolean isReappointType;
        boolean paramCheck = true;
        DynamicObject entity = dataEntity.getDataEntity();
        Date prePositiveDate = entity.getDate("prepositivedate");
        Date appointDate = entity.getDate("appointdate");
        Date planEndDate = entity.getDate("planenddate");
        boolean isEmptyDate = Objects.isNull(planEndDate) || Objects.isNull(appointDate);
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("appointtype"));
        boolean bl = isReappointType = 1472625044948646912L == appointTypeId;
        if (isReappointType) {
            DynamicObject aTenure;
            Date appointEndDate = entity.getDate("appointenddate");
            if (null == appointEndDate) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\"\u3002", (String)"NominateSubmitValidator_23", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
            if (null == (aTenure = entity.getDynamicObject("atenure"))) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u8fde\u4efb\u4efb\u5c97\"\u3002", (String)"NominateSubmitValidator_28", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        } else {
            Date appointEndDate;
            DynamicObject dTenure = entity.getDynamicObject("dismisstenure");
            if (null != dTenure && null == (appointEndDate = entity.getDate("appointenddate"))) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\"\u3002", (String)"NominateSubmitValidator_23", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
        if (Objects.isNull(prePositiveDate)) {
            if (!isEmptyDate && appointDate.compareTo(planEndDate) > 0) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u4efb\u671f\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"NominateSubmitValidator_7", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        } else {
            boolean checkAppointDate;
            boolean checkNotSuccess = false;
            if (!isEmptyDate) {
                checkNotSuccess = appointDate.compareTo(prePositiveDate) > 0 || prePositiveDate.compareTo(planEndDate) > 0;
            }
            boolean bl2 = checkAppointDate = null != appointDate && prePositiveDate.compareTo(appointDate) < 0;
            if (checkAppointDate || !isEmptyDate && checkNotSuccess) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u201c\u4efb\u671f\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\uff0c\u4e14\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"NominateSubmitValidator_8", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
        String positionType = entity.getString("positiontype");
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            DynamicObject aPosition = entity.getDynamicObject("aposition");
            if (null == aPosition) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u4efb\u5c97\u4f4d\"\u3002", (String)"NominateSubmitValidator_25", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            DynamicObject adminOrg;
            DynamicObject aJob = entity.getDynamicObject("ajob");
            if (null == aJob) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u4efb\u804c\u4f4d\"\u3002", (String)"NominateSubmitValidator_26", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
            if (null == (adminOrg = entity.getDynamicObject("aadminorg"))) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u4efb\u90e8\u95e8\"\u3002", (String)"NominateSubmitValidator_29", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            DynamicObject adminOrg;
            DynamicObject aStandardPosition = entity.getDynamicObject("astandardposition");
            if (null == aStandardPosition) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u4efb\u6807\u51c6\u5c97\u4f4d\"\u3002", (String)"NominateSubmitValidator_27", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
            if (null == (adminOrg = entity.getDynamicObject("aadminorg"))) {
                paramCheck = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u62df\u4efb\u90e8\u95e8\"\u3002", (String)"NominateSubmitValidator_29", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
        if (!this.recommendEntryValidator(dataEntity, entity)) {
            paramCheck = false;
        }
        return paramCheck;
    }

    private void positionValidate(ExtendedDataEntity dataEntity, Long billPkId, Map<Long, Map<Long, Integer>> dismissMap, Map<Long, List<DynamicObject>> emp2DyMap) {
        DynamicObject entity = dataEntity.getDataEntity();
        long dTenureId = 0L;
        DynamicObject dTenureDynamic = entity.getDynamicObject("dismisstenure");
        if (null != dTenureDynamic) {
            dTenureId = HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic);
        }
        if (!this.statusValidator(dataEntity, billPkId)) {
            return;
        }
        if (!this.oneBatchValidate(dataEntity, dTenureId, dismissMap, emp2DyMap)) {
            return;
        }
        if (!this.onWayValidate(dataEntity, dTenureDynamic)) {
            return;
        }
        if (!this.appointAndDismissValidator(dataEntity, billPkId, dTenureDynamic)) {
            return;
        }
        logger.info(MessageFormat.format("NominateSubmitValidator bill[{0}:{1}] must field and status validate is success", billPkId, entity.getString("billno")));
        try {
            Map resultMap = ACTV_SERVICE.getActivitySchemeMapFromWorkflow(entity);
            boolean success = (Boolean)resultMap.get("success");
            if (!success) {
                logger.error("getActivitySchemeMapFromWorkflow fail");
                String errorMsg = (String)resultMap.get("errorMsg");
                this.addFatalErrorMessage(dataEntity, errorMsg);
            }
        }
        catch (Exception exception) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6d3b\u52a8\u7f16\u6392\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NominateSubmitValidator_6", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            String message = MessageFormat.format("call hrcs error:{0}", entity.getString("billno"));
            logger.error(message, (Throwable)exception);
        }
    }

    private boolean oneBatchValidate(ExtendedDataEntity dataEntity, long dTenureId, Map<Long, Map<Long, Integer>> dismissMap, Map<Long, List<DynamicObject>> emp2DyMap) {
        String msg;
        long count;
        DynamicObject entity = dataEntity.getDataEntity();
        long aPositionId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("aposition"));
        long aJobId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("ajob"));
        long aStandardPositionId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("astandardposition"));
        long aAdminOrgId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("aadminorg"));
        long employeeId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("employee"));
        DynamicObject person = entity.getDynamicObject("person");
        boolean validate = Boolean.TRUE;
        List<DynamicObject> appointList = emp2DyMap.get(employeeId);
        if (0L != aPositionId && (count = appointList.stream().filter(p -> HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("aposition")) == aPositionId && HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("aadminorg")) == aAdminOrgId).count()) > 1L) {
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u201c{0}\u201d\u201c{1}\u201d\u91cd\u590d\u4efb\u547d\u3002", (String)"NominateSubmitValidator_13", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")});
            this.addFatalErrorMessage(dataEntity, msg);
            validate = Boolean.FALSE;
        }
        if (0L != aJobId && !CollectionUtils.isEmpty(appointList) && (count = appointList.stream().filter(p -> HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("ajob")) == aJobId && HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("aadminorg")) == aAdminOrgId).count()) > 1L) {
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u201c{0}\u201d\u201c{1}\u201d\u91cd\u590d\u4efb\u547d\u3002", (String)"NominateSubmitValidator_17", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")});
            this.addFatalErrorMessage(dataEntity, msg);
            validate = Boolean.FALSE;
        }
        if (0L != aStandardPositionId && !CollectionUtils.isEmpty(appointList) && (count = appointList.stream().filter(p -> HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("astandardposition")) == aStandardPositionId && HRDyObjectPropUtil.getId((DynamicObject)p.getDynamicObject("aadminorg")) == aAdminOrgId).count()) > 1L) {
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u201c{0}\u201d\u201c{1}\u201d\u91cd\u590d\u4efb\u547d\u3002", (String)"NominateSubmitValidator_18", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")});
            this.addFatalErrorMessage(dataEntity, msg);
            validate = Boolean.FALSE;
        }
        if (0L != dTenureId) {
            boolean result = this.oneBatchValidate(dismissMap, dataEntity, dTenureId, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u201c{0}\u201d\u201c{1}\u201d\u91cd\u590d\u4efb\u547d\u3002", (String)"NominateSubmitValidator_19", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")}));
            validate = result && validate;
        }
        return validate;
    }

    private boolean onWayValidate(ExtendedDataEntity dataEntity, DynamicObject dTenureDynamic) {
        Object[] dynamicObjects;
        DynamicObject entity = dataEntity.getDataEntity();
        Long aJobId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("ajob"));
        Long aStandardPositionId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("astandardposition"));
        Long aPositionId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("aposition"));
        long employeeId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("employee"));
        DynamicObject person = entity.getDynamicObject("person");
        if (0L != aPositionId) {
            long dPositionId = dTenureDynamic == null ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic.getDynamicObject("position"));
            dynamicObjects = tenureApplicationService.queryNonLeaveDataByEmployeeAndPosition("position,id", employeeId, aPositionId.longValue());
            if (ArrayUtils.isNotEmpty((Object[])dynamicObjects) && !aPositionId.equals(dPositionId)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u62df\u4efb\u547d\u5c97\u4f4d\u5df2\u6709\u751f\u6548\u4efb\u671f\u8bb0\u5f55\uff0c\u65e0\u6cd5\u91cd\u590d\u53d1\u8d77\u4efb\u547d\u3002", (String)"NominateSubmitValidator_12", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")}));
                return false;
            }
        }
        if (0L != aJobId) {
            long dJobId = dTenureDynamic == null ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic.getDynamicObject("job"));
            dynamicObjects = tenureApplicationService.queryNonLeaveDataByEmployeeAndJob("job,id", employeeId, aJobId.longValue());
            if (ArrayUtils.isNotEmpty((Object[])dynamicObjects) && !aJobId.equals(dJobId)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u62df\u4efb\u547d\u804c\u4f4d\u5df2\u6709\u751f\u6548\u4efb\u671f\u8bb0\u5f55\uff0c\u65e0\u6cd5\u91cd\u590d\u53d1\u8d77\u4efb\u547d\u3002", (String)"NominateSubmitValidator_20", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")}));
                return false;
            }
        }
        if (0L != aStandardPositionId) {
            long dStandardPositionId = dTenureDynamic == null ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic.getDynamicObject("standardpost"));
            dynamicObjects = tenureApplicationService.queryNonLeaveDataByEmployeeAndStandardPosition("standardpost,id", employeeId, aStandardPositionId.longValue());
            if (ArrayUtils.isNotEmpty((Object[])dynamicObjects) && !aStandardPositionId.equals(dStandardPositionId)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u62df\u4efb\u547d\u6807\u51c6\u5c97\u4f4d\u5df2\u6709\u751f\u6548\u4efb\u671f\u8bb0\u5f55\uff0c\u65e0\u6cd5\u91cd\u590d\u53d1\u8d77\u4efb\u547d\u3002", (String)"NominateSubmitValidator_21", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number")}));
                return false;
            }
        }
        return true;
    }

    private boolean oneBatchValidate(Map<Long, Map<Long, Integer>> map, ExtendedDataEntity dataEntity, long id, String msg) {
        DynamicObject entity = dataEntity.getDataEntity();
        Long employeeId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("employee"));
        if (id != 0L && map.get(employeeId) != null && map.get(employeeId).get(id) != null && map.get(employeeId).get(id) > 1) {
            this.addFatalErrorMessage(dataEntity, msg);
            return false;
        }
        return true;
    }

    private void validateDismiss(Map<Long, Map<Long, Integer>> dismissMap) {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject currentDataEntity = dataEntity.getDataEntity();
            long employeeId = HRDyObjectPropUtil.getId((DynamicObject)currentDataEntity.getDynamicObject("employee"));
            DynamicObject dTenureDynamic = currentDataEntity.getDynamicObject("dismisstenure");
            if (null == dTenureDynamic) continue;
            long tenurePkId = dTenureDynamic.getLong("id");
            Map countMap = dismissMap.getOrDefault(employeeId, new HashMap(16));
            Integer count = countMap.getOrDefault(tenurePkId, 0);
            count = count + 1;
            countMap.put(tenurePkId, count);
            dismissMap.put(employeeId, countMap);
        }
    }

    private boolean recommendEntryValidator(ExtendedDataEntity dataEntity, DynamicObject entity) {
        DynamicObjectCollection perCollection = entity.getDynamicObjectCollection("perrecommendentry");
        if (CollectionUtils.isEmpty((Collection)perCollection)) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        perCollection.forEach(dynamicObject -> {
            DynamicObjectCollection recommendDeptDynamicObject;
            DynamicObjectCollection referrerDynamicObject;
            String recommendSource = dynamicObject.getString("recommendsource");
            if (HRStringUtils.isEmpty((String)recommendSource)) {
                return;
            }
            if (RecommendSourceEnum.PERSON.getNumber().equals(recommendSource) && CollectionUtils.isEmpty((Collection)(referrerDynamicObject = (DynamicObjectCollection)dynamicObject.get("mulitreferrer")))) {
                result.set(false);
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u63d0\u540d\u63a8\u8350\"\u7b2c{0}\u884c:\"\u63a8\u8350\u4eba\"\u3002", (String)"NominateSubmitValidator_15", (String)"tdc-cadm-opplugin", (Object[])new Object[]{dynamicObject.getInt("seq")}));
                return;
            }
            if (RecommendSourceEnum.DEPT.getNumber().equals(recommendSource) && CollectionUtils.isEmpty((Collection)(recommendDeptDynamicObject = (DynamicObjectCollection)dynamicObject.get("muiltrecdept")))) {
                result.set(false);
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u63d0\u540d\u63a8\u8350\"\u7b2c{0}\u884c:\"\u63a8\u8350\u90e8\u95e8\"\u3002", (String)"NominateSubmitValidator_16", (String)"tdc-cadm-opplugin", (Object[])new Object[]{dynamicObject.getInt("seq")}));
            }
        });
        return result.get();
    }

    private boolean statusValidator(ExtendedDataEntity dataEntity, Long billPkId) {
        if (!HRObjectUtils.isEmpty((Object)billPkId) && billPkId != 0L) {
            DynamicObject bill = nominateApplicationService.getOriginalNominateBillById("appointstatus,nominatestatus", billPkId.longValue());
            String appointStatus = bill.getString("appointstatus");
            if (!AppointStatusEnum.WAIT_APPOINT.getVal().equals(appointStatus)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u4efb\u514d\u72b6\u6001\u4e3a\u201c\u5f85\u4efb\u514d\u201d\u7684\u6570\u636e\u3002", (String)"NominateSubmitValidator_2", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean appointAndDismissValidator(ExtendedDataEntity dataEntity, Long billPkId, DynamicObject dTenureDynamic) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObject person = entity.getDynamicObject("person");
        Long employeeId = HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("employee"));
        Long aAdminOrgId = entity.getDynamicObject("aadminorg") == null ? 0L : entity.getDynamicObject("aadminorg").getLong("boid");
        Long aPositionId = entity.getDynamicObject("aposition") == null ? 0L : entity.getDynamicObject("aposition").getLong("boid");
        Long aJobId = entity.getDynamicObject("ajob") == null ? 0L : entity.getDynamicObject("ajob").getLong("boid");
        Long aStandardPositionId = entity.getDynamicObject("astandardposition") == null ? 0L : entity.getDynamicObject("astandardposition").getLong("boid");
        DynamicObject[] nominateBills = nominateApplicationService.queryNominateByEmployee("billno,aposition,ajob,astandardposition,dposition,djob,dstandardposition,applykind,aadminorg", employeeId);
        long dPositionId = dTenureDynamic == null ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic.getDynamicObject("position"));
        long dJobId = dTenureDynamic == null ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic.getDynamicObject("job"));
        long dStandardPositionId = dTenureDynamic == null ? 0L : HRDyObjectPropUtil.getId((DynamicObject)dTenureDynamic.getDynamicObject("standardpost"));
        for (DynamicObject bill : nominateBills) {
            boolean isSameStdPosition;
            boolean condition;
            if (billPkId.equals(bill.getLong("id"))) continue;
            boolean checkSameAdminOrg = aAdminOrgId != 0L && aAdminOrgId.equals(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("aadminorg")));
            boolean checkSamePos = aPositionId != 0L && aPositionId.equals(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("aposition")));
            boolean checkSameJob = aJobId != 0L && aJobId.equals(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("ajob")));
            boolean checkSameStdPos = aStandardPositionId != 0L && aStandardPositionId.equals(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("astandardposition")));
            boolean bl = condition = checkSameAdminOrg && (checkSamePos || checkSameJob || checkSameStdPos);
            if (condition) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u7684\u4efb\u547d\u5df2\u5b58\u5728\u4e8e\"{2}\"\u4efb\u547d\u63d0\u540d\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"NominateSubmitValidator_9", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number"), bill.getString("billno")}));
                return false;
            }
            if (dPositionId == 0L && dJobId == 0L && dStandardPositionId == 0L) continue;
            long positionId = HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("dposition"));
            long jobId = HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("djob"));
            long stdPositionId = HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("dstandardposition"));
            boolean isSamePosition = positionId != 0L && dPositionId == positionId;
            boolean isSameJob = jobId != 0L && dJobId == jobId;
            boolean bl2 = isSameStdPosition = stdPositionId != 0L && dStandardPositionId == stdPositionId;
            if (!isSamePosition && !isSameJob && !isSameStdPosition) continue;
            String errorMsg = ApplyKindEnum.APPOINT.getNumber().equals(bill.getString("applykind")) ? ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u7684\u514d\u804c\u5df2\u5b58\u5728\u4e8e\"{2}\"\u4efb\u547d\u63d0\u540d\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"NominateSubmitValidator_11", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number"), bill.getString("billno")}) : ResManager.loadKDString((String)"\"{0}\" \"{1}\"\u7684\u514d\u804c\u5df2\u5b58\u5728\u4e8e\"{2}\"\u514d\u804c\u7533\u8bf7\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u91cd\u590d\u63d0\u4ea4\u3002", (String)"NominateSubmitValidator_10", (String)"tdc-cadm-opplugin", (Object[])new Object[]{person.getString("name"), person.getString("number"), bill.getString("billno")});
            this.addFatalErrorMessage(dataEntity, errorMsg);
            return false;
        }
        return true;
    }
}

