/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.publicity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;

public class PublicityWithdrawValidator
extends HRDataBaseValidator {
    private static final PublicityBillApplicationService SERVICE = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            this.validateBatchWithdraw((ExtendedDataEntity[])dataEntities);
        }
    }

    private void validateBatchWithdraw(ExtendedDataEntity[] dataEntities) {
        HashMap map = Maps.newHashMap();
        HashMap batchDynamics = Maps.newHashMap();
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject dynamic = dataEntity.getDataEntity();
            String batchNum = dynamic.getString("pubbatchnum");
            if (HRStringUtils.isBlank((CharSequence)batchNum)) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u56de\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u8fdb\u5165\u516c\u793a\u671f/\u516c\u793a\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"PublicityWithdrawValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
                return;
            }
            if (map.containsKey(batchNum)) {
                return;
            }
            DynamicObject[] byPubBatchNum = SERVICE.getByPubBatchNum("pubbatchnum,pubstatus", batchNum);
            if (byPubBatchNum == null || byPubBatchNum.length == 0) {
                return;
            }
            batchDynamics.put(batchNum, dataEntity);
            List statusList = Arrays.stream(byPubBatchNum).map(dynamicObject -> dynamicObject.getString("pubstatus")).collect(Collectors.toList());
            map.put(batchNum, statusList);
        });
        int size = map.size();
        if (size == 0) {
            return;
        }
        map.forEach((batchNum, statusList) -> {
            ArrayList canBenWithdrawList = Lists.newArrayList();
            statusList.forEach(status -> canBenWithdrawList.add(PublicityStatusEnum.canBeWithdraw((String)status)));
            boolean contains = canBenWithdrawList.contains(Boolean.FALSE);
            if (!contains) {
                return;
            }
            if (canBenWithdrawList.size() == 1 && size == 1) {
                this.validateContext.setValidatePrefix("pubbatchnum");
                this.addFatalErrorMessage((ExtendedDataEntity)batchDynamics.get(batchNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64a4\u56de\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u8fdb\u5165\u516c\u793a\u671f/\u516c\u793a\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"PublicityWithdrawValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            } else {
                this.validateContext.setValidatePrefix("pubbatchnum");
                this.addFatalErrorMessage((ExtendedDataEntity)batchDynamics.get(batchNum), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u9009\u4e2d\u7684\u516c\u793a\u6279\u6b21\u4e0b\u6709\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u516c\u793a\u4e2d\u201d\u6216\u201c\u8fdb\u5165\u516c\u793a\u671f\u201d\u3002", (String)"PublicityWithdrawValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        });
    }
}

