/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.release;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;

public class ReleaseRejectValidator
extends HRDataBaseValidator {
    private static final ReleaseBillApplicationService SERVICE = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            List billPkIds = Arrays.stream(dataEntities).map(releaseBill -> (Long)releaseBill.getBillPkId()).collect(Collectors.toList());
            DynamicObject[] bills = SERVICE.getOriginalReleaseBillById("id,releaseStatus", billPkIds);
            Map<Long, DynamicObject> billMap = Arrays.stream(bills).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (v1, v2) -> v1));
            for (Object dataEntity : dataEntities) {
                String status = billMap.get(dataEntity.getDataEntity().getLong("id")).getString("releasestatus");
                if (ReleaseStatusEnum.canBeRejected((String)status)) continue;
                this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u9a73\u56de\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03/\u5f85\u53d1\u5e03\u751f\u6548/\u5f85\u91cd\u65b0\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", (String)"ReleaseRejectValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

