/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.resume;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;

public class CadreResumePrintValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!HRArrayUtils.isEmpty((Object[])dataEntities)) {
            this.mustInputValidate((ExtendedDataEntity[])dataEntities);
        }
        this.setErrorInfoBefore();
    }

    private void setErrorInfoBefore() {
        String operateKey = this.getOperateKey();
        if ("formprint".equals(operateKey)) {
            return;
        }
        List validateErrors = this.validateContext.getValidateResults().getValidateErrors();
        if (CollectionUtils.isEmpty((Collection)validateErrors)) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        validateErrors.forEach(validateError -> {
            List allErrorInfo = validateError.getAllErrorInfo();
            if (CollectionUtils.isEmpty((Collection)allErrorInfo)) {
                return;
            }
            Map<Long, DynamicObject> pkMap = Arrays.stream(dataEntities).collect(Collectors.toMap(dataEntity -> dataEntity.getDataEntity().getLong("id"), dataEntity -> dataEntity.getDataEntity(), (v1, v2) -> v1));
            allErrorInfo.forEach(errorInfo -> {
                Object pkValue = errorInfo.getPkValue();
                DynamicObject dynamicObject = (DynamicObject)pkMap.get(Long.parseLong(pkValue.toString()));
                String number = dynamicObject.getString("person.number");
                if (HRStringUtils.isBlank((CharSequence)number)) {
                    return;
                }
                String message = errorInfo.getMessage();
                errorInfo.setMessage(number + ": " + message);
            });
        });
    }

    private void mustInputValidate(ExtendedDataEntity[] dataEntities) {
        Arrays.stream(dataEntities).forEach(extendedDataEntity -> {
            String idNumber = extendedDataEntity.getDataEntity().getString("idnumber");
            if (HRStringUtils.isBlank((CharSequence)idNumber)) {
                return;
            }
            boolean isPass = ExternalDataService.validateIdNumber((String)idNumber);
            if (!isPass) {
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\"\u516c\u6c11\u8eab\u4efd\u8bc1\u53f7\"\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CadreResumeSaveValidator_9", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        });
    }
}

