/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.opplugin.validator.resume;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CadreResumeSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Arrays.stream(dataEntities).forEach(extendedDataEntity -> {
            this.learnEndDateBeforeStart((ExtendedDataEntity)extendedDataEntity);
            this.workEndDateBeforeStart((ExtendedDataEntity)extendedDataEntity);
            this.sameDataValidate((ExtendedDataEntity)extendedDataEntity);
            this.wifeDateValidator((ExtendedDataEntity)extendedDataEntity);
        });
    }

    private void wifeDateValidator(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject marriedStatus = dataEntity.getDynamicObject("marriagestatus");
        if (null != marriedStatus && 1020L == marriedStatus.getLong("id")) {
            Date sBirthDay = dataEntity.getDate("sbirthday");
            Date sJoinWorkTime = dataEntity.getDate("sjoinworktime");
            if (null == sBirthDay || sJoinWorkTime == null) {
                return;
            }
            if (!this.ifEndGreaterStart(sBirthDay, sJoinWorkTime)) {
                this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u914d\u5076\u4fe1\u606f-\u51fa\u751f\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u201c\u53c2\u52a0\u5de5\u4f5c\u65f6\u95f4\u201d\u3002", (String)"CadreResumeSaveValidator_10", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void workEndDateBeforeStart(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection workEntryEntity = dataEntity.getDynamicObjectCollection("workentryentity");
        if (CollectionUtils.isEmpty((Collection)workEntryEntity)) {
            return;
        }
        workEntryEntity.forEach(dynamicObject -> {
            Date endDate;
            int seq = dynamicObject.getInt("seq");
            Date startDate = dynamicObject.getDate("startdate");
            if (!this.ifEndGreaterStart(startDate, endDate = dynamicObject.getDate("enddate"))) {
                this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5de5\u4f5c\u7ecf\u5386-\u7b2c{0}\u884c\uff0c\u201c\u5f00\u59cb\u5e74\u6708\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u7ed3\u675f\u5e74\u6708\u201d\u3002", (String)"CadreResumeSaveValidator_8", (String)"tdc-cadm-opplugin", (Object[])new Object[]{seq}));
            }
        });
    }

    private void learnEndDateBeforeStart(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObjectCollection learnEntryEntity = dataEntity.getDynamicObjectCollection("learnentryentity");
        if (CollectionUtils.isEmpty((Collection)learnEntryEntity)) {
            return;
        }
        learnEntryEntity.forEach(dynamicObject -> {
            Date graduationDate;
            int seq = dynamicObject.getInt("seq");
            Date admissionDate = dynamicObject.getDate("admissiondate");
            if (!this.ifEndGreaterStart(admissionDate, graduationDate = dynamicObject.getDate("gradutiondate"))) {
                this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b66\u4e60\u7b80\u5386-\u7b2c{0}\u884c\uff0c\u201c\u5165\u5b66\u5e74\u6708\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u6bd5\u4e1a\u5e74\u6708\u201d\u3002", (String)"CadreResumeSaveValidator_7", (String)"tdc-cadm-opplugin", (Object[])new Object[]{seq}));
            }
        });
    }

    private boolean ifEndGreaterStart(Date startDate, Date endDate) {
        if (null == startDate || endDate == null) {
            return true;
        }
        int endMonth = HRDateTimeUtils.getMonth((Date)endDate);
        int endYear = HRDateTimeUtils.getYear((Date)endDate);
        int startMonth = HRDateTimeUtils.getMonth((Date)startDate);
        int startYear = HRDateTimeUtils.getYear((Date)startDate);
        if (endYear < startYear) {
            return false;
        }
        return endYear != startYear || endMonth >= startMonth;
    }

    private void sameDataValidate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        ArrayList failMessageList = Lists.newArrayList();
        this.learnEntrySameValidate(dataEntity, failMessageList);
        this.workEntrySameValidate(dataEntity, failMessageList);
        this.inPartyEntrySameValidate(dataEntity, failMessageList);
        this.inFamilyEntrySameValidate(dataEntity, failMessageList);
        this.socialEntrySameValidate(dataEntity, failMessageList);
        if (CollectionUtils.isEmpty((Collection)failMessageList)) {
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"{0}\u5b58\u5728\u91cd\u590d\u6dfb\u52a0\u7684\u6570\u636e\u884c\uff0c\u8bf7\u5148\u5220\u9664\u540e\u518d\u4fdd\u5b58\u3002", (String)"CadreResumeSaveValidator_0", (String)"tdc-cadm-opplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", failMessageList)});
        this.addFatalErrorMessage(extendedDataEntity, errorMessage);
    }

    private void socialEntrySameValidate(DynamicObject dataEntity, List<String> failMessageList) {
        DynamicObjectCollection socialEntry = dataEntity.getDynamicObjectCollection("cadresocialreentryentity");
        if (CollectionUtils.isEmpty((Collection)socialEntry)) {
            return;
        }
        ArrayList valueStrList = Lists.newArrayList();
        socialEntry.forEach(dynamicObject -> {
            String appellation = dynamicObject.getString("appellation");
            if (HRStringUtils.isBlank((CharSequence)appellation)) {
                appellation = "";
            }
            this.appendMemberInfo((DynamicObject)dynamicObject, appellation, "socialbirthday", "name", "socialpoliticalstatus", "socialworkunitposition", valueStrList);
        });
        if (this.ifHadSameValue(valueStrList)) {
            failMessageList.add(ResManager.loadKDString((String)"\"\u91cd\u8981\u793e\u4f1a\u5173\u7cfb\u60c5\u51b5\"", (String)"CadreResumeSaveValidator_1", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }

    private void inFamilyEntrySameValidate(DynamicObject dataEntity, List<String> failMessageList) {
        DynamicObjectCollection familyEntryEntity = dataEntity.getDynamicObjectCollection("familyentryentity");
        if (CollectionUtils.isEmpty((Collection)familyEntryEntity)) {
            return;
        }
        ArrayList valueStrList = Lists.newArrayList();
        familyEntryEntity.forEach(dynamicObject -> {
            String familyMemberShipName;
            String string = familyMemberShipName = dynamicObject.getDynamicObject("familymembship") == null ? "" : HRDyObjectPropUtil.getName((DynamicObject)dynamicObject.getDynamicObject("familymembship"));
            if (HRStringUtils.isBlank((CharSequence)familyMemberShipName)) {
                familyMemberShipName = "";
            }
            this.appendMemberInfo((DynamicObject)dynamicObject, familyMemberShipName, "familybirthday", "familymembername", "familypoliticalstatus", "familyworkunitposition", valueStrList);
        });
        if (this.ifHadSameValue(valueStrList)) {
            failMessageList.add(ResManager.loadKDString((String)"\"\u5bb6\u5ead\u6210\u5458-\u5176\u4ed6\u6210\u5458\"", (String)"CadreResumeSaveValidator_2", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }

    private void appendMemberInfo(DynamicObject dynamicObject, String shipName, String birthdayKey, String nameKey, String politicalKey, String workPositionKey, List<String> valueStrList) {
        String append;
        String workUnitPosition;
        String politicalStatus;
        int seq = dynamicObject.getInt("seq");
        String name = dynamicObject.getString(nameKey);
        if (HRStringUtils.isBlank((CharSequence)name)) {
            name = "";
        }
        Date birthday = dynamicObject.getDate(birthdayKey);
        String birthdayStr = "";
        if (null != birthday) {
            birthdayStr = HRDateTimeUtils.format((Date)birthday, (String)"yyyy.MM");
        }
        String string = politicalStatus = dynamicObject.getDynamicObject(politicalKey) == null ? "" : HRDyObjectPropUtil.getName((DynamicObject)dynamicObject.getDynamicObject(politicalKey));
        if (HRStringUtils.isBlank((CharSequence)politicalStatus)) {
            politicalStatus = "";
        }
        if (HRStringUtils.isBlank((CharSequence)(workUnitPosition = dynamicObject.getString(workPositionKey)))) {
            workUnitPosition = "";
        }
        if (HRStringUtils.isBlank((CharSequence)(append = birthdayStr + shipName + name + politicalStatus + workUnitPosition))) {
            return;
        }
        valueStrList.add(seq + "," + append);
    }

    private void inPartyEntrySameValidate(DynamicObject dataEntity, List<String> failMessageList) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        ArrayList valueStrList = Lists.newArrayList();
        entryEntity.forEach(dynamicObject -> {
            String append;
            String identityPosition;
            String congressName;
            int seq = dynamicObject.getInt("seq");
            Date electionDate = dynamicObject.getDate("electiondate");
            String electionDateStr = "";
            if (null != electionDate) {
                electionDateStr = HRDateTimeUtils.format((Date)electionDate, (String)"yyyy.MM");
            }
            if (HRStringUtils.isBlank((CharSequence)(congressName = dynamicObject.getString("congressname")))) {
                congressName = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(identityPosition = dynamicObject.getString("identityposition")))) {
                identityPosition = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(append = electionDateStr + congressName + identityPosition))) {
                return;
            }
            valueStrList.add(seq + "," + append);
        });
        if (this.ifHadSameValue(valueStrList)) {
            failMessageList.add(ResManager.loadKDString((String)"\"\u5f53\u9009\u4f1a\u8bae\u3001\u515a\u6d3e\u4ee3\u8868\u3001\u59d4\u5458\u60c5\u51b5\"", (String)"CadreResumeSaveValidator_3", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }

    private void workEntrySameValidate(DynamicObject dataEntity, List<String> failMessageList) {
        DynamicObjectCollection workEntryEntity = dataEntity.getDynamicObjectCollection("workentryentity");
        if (CollectionUtils.isEmpty((Collection)workEntryEntity)) {
            return;
        }
        ArrayList valueStrList = Lists.newArrayList();
        workEntryEntity.forEach(dynamicObject -> {
            String append;
            String workReference;
            String unitName;
            int seq = dynamicObject.getInt("seq");
            Date startDate = dynamicObject.getDate("startdate");
            String startDateStr = "";
            if (null != startDate) {
                startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy.MM");
            }
            Date endDate = dynamicObject.getDate("enddate");
            String endDateStr = "";
            if (null != endDate) {
                endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy.MM");
            }
            if (HRStringUtils.isBlank((CharSequence)(unitName = dynamicObject.getString("unitname")))) {
                unitName = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(workReference = dynamicObject.getString("workreterence")))) {
                workReference = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(append = startDateStr + endDateStr + unitName + workReference))) {
                return;
            }
            valueStrList.add(seq + "," + append);
        });
        if (this.ifHadSameValue(valueStrList)) {
            failMessageList.add(ResManager.loadKDString((String)"\"\u5de5\u4f5c\u7ecf\u5386\"", (String)"CadreResumeSaveValidator_4", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }

    private void learnEntrySameValidate(DynamicObject dataEntity, List<String> failMessageList) {
        DynamicObjectCollection learnEntryEntity = dataEntity.getDynamicObjectCollection("learnentryentity");
        if (CollectionUtils.isEmpty((Collection)learnEntryEntity)) {
            return;
        }
        ArrayList valueStrList = Lists.newArrayList();
        learnEntryEntity.forEach(dynamicObject -> {
            String append;
            String learnReference;
            String graduation;
            String collegeDeptMajor;
            int seq = dynamicObject.getInt("seq");
            Date admissionDate = dynamicObject.getDate("admissiondate");
            String admissionDateStr = "";
            if (null != admissionDate) {
                admissionDateStr = HRDateTimeUtils.format((Date)admissionDate, (String)"yyyy.MM");
            }
            Date graduationDate = dynamicObject.getDate("gradutiondate");
            String graduationDateStr = "";
            if (null != graduationDate) {
                graduationDateStr = HRDateTimeUtils.format((Date)graduationDate, (String)"yyyy.MM");
            }
            if (HRStringUtils.isBlank((CharSequence)(collegeDeptMajor = dynamicObject.getString("collegedeptmajor")))) {
                collegeDeptMajor = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(graduation = dynamicObject.getString("graduation")))) {
                graduation = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(learnReference = dynamicObject.getString("learnreterence")))) {
                learnReference = "";
            }
            if (HRStringUtils.isBlank((CharSequence)(append = admissionDateStr + graduationDateStr + collegeDeptMajor + graduation + learnReference))) {
                return;
            }
            valueStrList.add(seq + "," + append);
        });
        if (this.ifHadSameValue(valueStrList)) {
            failMessageList.add(ResManager.loadKDString((String)"\"\u5b66\u4e60\u7b80\u5386\"", (String)"CadreResumeSaveValidator_5", (String)"tdc-cadm-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean ifHadSameValue(List<String> valueStrList) {
        AtomicBoolean flag = new AtomicBoolean(Boolean.FALSE);
        valueStrList.forEach(value -> {
            String[] split = value.split(",");
            String seq = split[0];
            String valueStr = "";
            if (split.length == 2) {
                valueStr = split[1];
            }
            String finalValueStr = valueStr;
            valueStrList.forEach(inValue -> {
                if (value.equals(inValue)) {
                    return;
                }
                String[] inValueArray = inValue.split(",");
                String inSeq = inValueArray[0];
                String inValueStr = "";
                if (inValueArray.length == 2) {
                    inValueStr = inValueArray[1];
                }
                if (!seq.equals(inSeq) && finalValueStr.equals(inValueStr)) {
                    flag.set(Boolean.TRUE);
                }
            });
        });
        return flag.get();
    }
}

